/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// IntegrationStatusApplyConfiguration represents an declarative configuration of the IntegrationStatus type for use
// with apply.
type IntegrationStatusApplyConfiguration struct {
	ObservedGeneration      *int64                                   `json:"observedGeneration,omitempty"`
	Phase                   *v1.IntegrationPhase                     `json:"phase,omitempty"`
	Digest                  *string                                  `json:"digest,omitempty"`
	Image                   *string                                  `json:"image,omitempty"`
	Dependencies            []string                                 `json:"dependencies,omitempty"`
	Profile                 *v1.TraitProfile                         `json:"profile,omitempty"`
	IntegrationKit          *corev1.ObjectReference                  `json:"integrationKit,omitempty"`
	Platform                *string                                  `json:"platform,omitempty"`
	GeneratedSources        []SourceSpecApplyConfiguration           `json:"generatedSources,omitempty"`
	RuntimeVersion          *string                                  `json:"runtimeVersion,omitempty"`
	RuntimeProvider         *v1.RuntimeProvider                      `json:"runtimeProvider,omitempty"`
	Configuration           []ConfigurationSpecApplyConfiguration    `json:"configuration,omitempty"`
	Conditions              []IntegrationConditionApplyConfiguration `json:"conditions,omitempty"`
	Version                 *string                                  `json:"version,omitempty"`
	Replicas                *int32                                   `json:"replicas,omitempty"`
	Selector                *string                                  `json:"selector,omitempty"`
	Capabilities            []string                                 `json:"capabilities,omitempty"`
	InitializationTimestamp *metav1.Time                             `json:"lastInitTimestamp,omitempty"`
}

// IntegrationStatusApplyConfiguration constructs an declarative configuration of the IntegrationStatus type for use with
// apply.
func IntegrationStatus() *IntegrationStatusApplyConfiguration {
	return &IntegrationStatusApplyConfiguration{}
}

// WithObservedGeneration sets the ObservedGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObservedGeneration field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithObservedGeneration(value int64) *IntegrationStatusApplyConfiguration {
	b.ObservedGeneration = &value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithPhase(value v1.IntegrationPhase) *IntegrationStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithDigest sets the Digest field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Digest field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithDigest(value string) *IntegrationStatusApplyConfiguration {
	b.Digest = &value
	return b
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithImage(value string) *IntegrationStatusApplyConfiguration {
	b.Image = &value
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *IntegrationStatusApplyConfiguration) WithDependencies(values ...string) *IntegrationStatusApplyConfiguration {
	for i := range values {
		b.Dependencies = append(b.Dependencies, values[i])
	}
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithProfile(value v1.TraitProfile) *IntegrationStatusApplyConfiguration {
	b.Profile = &value
	return b
}

// WithIntegrationKit sets the IntegrationKit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IntegrationKit field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithIntegrationKit(value corev1.ObjectReference) *IntegrationStatusApplyConfiguration {
	b.IntegrationKit = &value
	return b
}

// WithPlatform sets the Platform field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Platform field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithPlatform(value string) *IntegrationStatusApplyConfiguration {
	b.Platform = &value
	return b
}

// WithGeneratedSources adds the given value to the GeneratedSources field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the GeneratedSources field.
func (b *IntegrationStatusApplyConfiguration) WithGeneratedSources(values ...*SourceSpecApplyConfiguration) *IntegrationStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithGeneratedSources")
		}
		b.GeneratedSources = append(b.GeneratedSources, *values[i])
	}
	return b
}

// WithRuntimeVersion sets the RuntimeVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuntimeVersion field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithRuntimeVersion(value string) *IntegrationStatusApplyConfiguration {
	b.RuntimeVersion = &value
	return b
}

// WithRuntimeProvider sets the RuntimeProvider field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuntimeProvider field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithRuntimeProvider(value v1.RuntimeProvider) *IntegrationStatusApplyConfiguration {
	b.RuntimeProvider = &value
	return b
}

// WithConfiguration adds the given value to the Configuration field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Configuration field.
func (b *IntegrationStatusApplyConfiguration) WithConfiguration(values ...*ConfigurationSpecApplyConfiguration) *IntegrationStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConfiguration")
		}
		b.Configuration = append(b.Configuration, *values[i])
	}
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *IntegrationStatusApplyConfiguration) WithConditions(values ...*IntegrationConditionApplyConfiguration) *IntegrationStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithVersion(value string) *IntegrationStatusApplyConfiguration {
	b.Version = &value
	return b
}

// WithReplicas sets the Replicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Replicas field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithReplicas(value int32) *IntegrationStatusApplyConfiguration {
	b.Replicas = &value
	return b
}

// WithSelector sets the Selector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Selector field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithSelector(value string) *IntegrationStatusApplyConfiguration {
	b.Selector = &value
	return b
}

// WithCapabilities adds the given value to the Capabilities field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Capabilities field.
func (b *IntegrationStatusApplyConfiguration) WithCapabilities(values ...string) *IntegrationStatusApplyConfiguration {
	for i := range values {
		b.Capabilities = append(b.Capabilities, values[i])
	}
	return b
}

// WithInitializationTimestamp sets the InitializationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InitializationTimestamp field is set to the value of the last call.
func (b *IntegrationStatusApplyConfiguration) WithInitializationTimestamp(value metav1.Time) *IntegrationStatusApplyConfiguration {
	b.InitializationTimestamp = &value
	return b
}
