/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/apache/camel-k/pkg/apis/camel/v1alpha1"
)

// KameletBindingStatusApplyConfiguration represents an declarative configuration of the KameletBindingStatus type for use
// with apply.
type KameletBindingStatusApplyConfiguration struct {
	ObservedGeneration *int64                                      `json:"observedGeneration,omitempty"`
	Phase              *v1alpha1.KameletBindingPhase               `json:"phase,omitempty"`
	Conditions         []KameletBindingConditionApplyConfiguration `json:"conditions,omitempty"`
	Replicas           *int32                                      `json:"replicas,omitempty"`
	Selector           *string                                     `json:"selector,omitempty"`
}

// KameletBindingStatusApplyConfiguration constructs an declarative configuration of the KameletBindingStatus type for use with
// apply.
func KameletBindingStatus() *KameletBindingStatusApplyConfiguration {
	return &KameletBindingStatusApplyConfiguration{}
}

// WithObservedGeneration sets the ObservedGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObservedGeneration field is set to the value of the last call.
func (b *KameletBindingStatusApplyConfiguration) WithObservedGeneration(value int64) *KameletBindingStatusApplyConfiguration {
	b.ObservedGeneration = &value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *KameletBindingStatusApplyConfiguration) WithPhase(value v1alpha1.KameletBindingPhase) *KameletBindingStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *KameletBindingStatusApplyConfiguration) WithConditions(values ...*KameletBindingConditionApplyConfiguration) *KameletBindingStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithReplicas sets the Replicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Replicas field is set to the value of the last call.
func (b *KameletBindingStatusApplyConfiguration) WithReplicas(value int32) *KameletBindingStatusApplyConfiguration {
	b.Replicas = &value
	return b
}

// WithSelector sets the Selector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Selector field is set to the value of the last call.
func (b *KameletBindingStatusApplyConfiguration) WithSelector(value string) *KameletBindingStatusApplyConfiguration {
	b.Selector = &value
	return b
}
