/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	camelv1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-k/pkg/client/camel/applyconfiguration/camel/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIntegrationKits implements IntegrationKitInterface
type FakeIntegrationKits struct {
	Fake *FakeCamelV1
	ns   string
}

var integrationkitsResource = schema.GroupVersionResource{Group: "camel.apache.org", Version: "v1", Resource: "integrationkits"}

var integrationkitsKind = schema.GroupVersionKind{Group: "camel.apache.org", Version: "v1", Kind: "IntegrationKit"}

// Get takes name of the integrationKit, and returns the corresponding integrationKit object, and an error if there is any.
func (c *FakeIntegrationKits) Get(ctx context.Context, name string, options v1.GetOptions) (result *camelv1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(integrationkitsResource, c.ns, name), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// List takes label and field selectors, and returns the list of IntegrationKits that match those selectors.
func (c *FakeIntegrationKits) List(ctx context.Context, opts v1.ListOptions) (result *camelv1.IntegrationKitList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(integrationkitsResource, integrationkitsKind, c.ns, opts), &camelv1.IntegrationKitList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &camelv1.IntegrationKitList{ListMeta: obj.(*camelv1.IntegrationKitList).ListMeta}
	for _, item := range obj.(*camelv1.IntegrationKitList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested integrationKits.
func (c *FakeIntegrationKits) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(integrationkitsResource, c.ns, opts))

}

// Create takes the representation of a integrationKit and creates it.  Returns the server's representation of the integrationKit, and an error, if there is any.
func (c *FakeIntegrationKits) Create(ctx context.Context, integrationKit *camelv1.IntegrationKit, opts v1.CreateOptions) (result *camelv1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(integrationkitsResource, c.ns, integrationKit), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// Update takes the representation of a integrationKit and updates it. Returns the server's representation of the integrationKit, and an error, if there is any.
func (c *FakeIntegrationKits) Update(ctx context.Context, integrationKit *camelv1.IntegrationKit, opts v1.UpdateOptions) (result *camelv1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(integrationkitsResource, c.ns, integrationKit), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeIntegrationKits) UpdateStatus(ctx context.Context, integrationKit *camelv1.IntegrationKit, opts v1.UpdateOptions) (*camelv1.IntegrationKit, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(integrationkitsResource, "status", c.ns, integrationKit), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// Delete takes name of the integrationKit and deletes it. Returns an error if one occurs.
func (c *FakeIntegrationKits) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(integrationkitsResource, c.ns, name, opts), &camelv1.IntegrationKit{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIntegrationKits) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(integrationkitsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &camelv1.IntegrationKitList{})
	return err
}

// Patch applies the patch and returns the patched integrationKit.
func (c *FakeIntegrationKits) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *camelv1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationkitsResource, c.ns, name, pt, data, subresources...), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied integrationKit.
func (c *FakeIntegrationKits) Apply(ctx context.Context, integrationKit *applyconfigurationcamelv1.IntegrationKitApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.IntegrationKit, err error) {
	if integrationKit == nil {
		return nil, fmt.Errorf("integrationKit provided to Apply must not be nil")
	}
	data, err := json.Marshal(integrationKit)
	if err != nil {
		return nil, err
	}
	name := integrationKit.Name
	if name == nil {
		return nil, fmt.Errorf("integrationKit.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationkitsResource, c.ns, *name, types.ApplyPatchType, data), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeIntegrationKits) ApplyStatus(ctx context.Context, integrationKit *applyconfigurationcamelv1.IntegrationKitApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.IntegrationKit, err error) {
	if integrationKit == nil {
		return nil, fmt.Errorf("integrationKit provided to Apply must not be nil")
	}
	data, err := json.Marshal(integrationKit)
	if err != nil {
		return nil, err
	}
	name := integrationKit.Name
	if name == nil {
		return nil, fmt.Errorf("integrationKit.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationkitsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &camelv1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.IntegrationKit), err
}
