/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.cronsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCronsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_CONF = "camel.kamelet.cron-source.schedule";
    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_DOC = "A cron expression that will be used to trigger events generation. Example: 0/3 10 * * * ?";
    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_DEFAULT = null;
    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_CONF = "camel.kamelet.cron-source.message";
    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_DOC = "The message to generate Example: hello world";
    public static final String CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_DEFAULT = null;

    public CamelCronsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCronsourceSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_CRONSOURCE_KAMELET_SCHEDULE_DOC);
        conf.define(CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_CRONSOURCE_KAMELET_MESSAGE_DOC);
        return conf;
    }
}