/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.logsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelLogsinkSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_CONF = "camel.kamelet.log-sink.showHeaders";
    public static final String CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_DOC = "Show the headers received";
    public static final Boolean CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_CONF = "camel.kamelet.log-sink.showStreams";
    public static final String CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_DOC = "Show the stream bodies (they may not be available in following steps)";
    public static final Boolean CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_DEFAULT = false;

    public CamelLogsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelLogsinkSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LOGSINK_KAMELET_SHOW_HEADERS_DOC);
        conf.define(CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LOGSINK_KAMELET_SHOW_STREAMS_DOC);
        return conf;
    }
}