/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.solrsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSolrsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_CONF = "camel.kamelet.solr-sink.collection";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_DOC = "Solr Collection name";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_DEFAULT = null;
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_CONF = "camel.kamelet.solr-sink.servers";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_DOC = "Comma separated list of Solr Servers and ports";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_DEFAULT = null;
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_CONF = "camel.kamelet.solr-sink.autocommit";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_DOC = "If autocommit should be enabled or not";
    public static final Boolean CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_DEFAULT = false;
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_CONF = "camel.kamelet.solr-sink.username";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_DOC = "Username to connect to Solr.";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_CONF = "camel.kamelet.solr-sink.password";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_DOC = "Password to connect to Solr.";
    public static final String CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_DEFAULT = null;

    public CamelSolrsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSolrsinkSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SOLRSINK_KAMELET_COLLECTION_DOC);
        conf.define(CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SOLRSINK_KAMELET_SERVERS_DOC);
        conf.define(CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOLRSINK_KAMELET_AUTOCOMMIT_DOC);
        conf.define(CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOLRSINK_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOLRSINK_KAMELET_PASSWORD_DOC);
        return conf;
    }
}