/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.splunksource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSplunksourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_CONF = "camel.kamelet.splunk-source.serverHostname";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_DOC = "The address of your Splunk server. Example: my_server_splunk.com";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_CONF = "camel.kamelet.splunk-source.serverPort";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_DOC = "The address of your Splunk server.";
    public static final Integer CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_DEFAULT = 8089;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_CONF = "camel.kamelet.splunk-source.username";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_DOC = "The username to authenticate to Splunk Server.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_CONF = "camel.kamelet.splunk-source.password";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_DOC = "The password to authenticate to Splunk Server.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_CONF = "camel.kamelet.splunk-source.index";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_DOC = "Splunk index to write to.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_CONF = "camel.kamelet.splunk-source.protocol";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_DOC = "Connection Protocol to Splunk server.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_DEFAULT = "https";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_CONF = "camel.kamelet.splunk-source.source";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_DOC = "The source named field of the data.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_CONF = "camel.kamelet.splunk-source.sourceType";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_DOC = "The source named field of the data.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_CONF = "camel.kamelet.splunk-source.app";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_DOC = "The app name in Splunk.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_CONF = "camel.kamelet.splunk-source.connectionTimeout";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_DOC = "Timeout in milliseconds when connecting to Splunk server";
    public static final Integer CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_CONF = "camel.kamelet.splunk-source.count";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_DOC = "The maximum number of entities to return.";
    public static final Integer CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_CONF = "camel.kamelet.splunk-source.repeat";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_DOC = "The maximum number of fires.";
    public static final Integer CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_CONF = "camel.kamelet.splunk-source.delay";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_DOC = "The number of milliseconds before the next poll.";
    public static final Integer CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_CONF = "camel.kamelet.splunk-source.query";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_DOC = "The Splunk query to run.";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_CONF = "camel.kamelet.splunk-source.earliestTime";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_DOC = "Earliest time of the search time window. Example: 05/17/22 08:35:46:456";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_CONF = "camel.kamelet.splunk-source.initEarliestTime";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_DOC = "Initial start offset of the first search. Example: 05/17/22 08:35:46:456";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_CONF = "camel.kamelet.splunk-source.latestTime";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_DOC = "Latest time of the search time window. Example: 05/17/22 08:35:46:456";
    public static final String CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_DEFAULT = null;

    public CamelSplunksourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSplunksourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SERVER_PORT_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INDEX_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_SOURCE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_APP_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_COUNT_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_REPEAT_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_DELAY_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_QUERY_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_EARLIEST_TIME_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_INIT_EARLIEST_TIME_DOC);
        conf.define(CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPLUNKSOURCE_KAMELET_LATEST_TIME_DOC);
        return conf;
    }
}