/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.wttrinsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelWttrinsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_CONF = "camel.kamelet.wttrin-source.period";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_DOC = "The interval between fetches to the wttr.in service in milliseconds";
    public static final Integer CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_DEFAULT = 60000;
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_CONF = "camel.kamelet.wttrin-source.wttrLocation";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_DOC = "\"paris, ~Eiffel+tower, Москва, muc, @stackoverflow.com, 94107, -78.46,106.79";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_CONF = "camel.kamelet.wttrin-source.wttrLanguage";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_DOC = "The language to use for displaying weather forecasts Example: am ar af be bn ca da de el et fr fa hi hu ia id it lt mg nb nl oc pl pt-br ro ru ta tr th uk vi zh-cn zh-tw";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_DEFAULT = null;
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_CONF = "camel.kamelet.wttrin-source.output";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_DOC = "The type of output Example: current, weather, full";
    public static final String CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_DEFAULT = "current";

    public CamelWttrinsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelWttrinsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_PERIOD_DOC);
        conf.define(CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LOCATION_DOC);
        conf.define(CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_WTTR_LANGUAGE_DOC);
        conf.define(CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WTTRINSOURCE_KAMELET_OUTPUT_DOC);
        return conf;
    }
}