# ---------------------------------------------------------------------------
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ---------------------------------------------------------------------------

Feature: Mail Sink

  Background:
    Given variables
      | host      | yaks:env('MAIL_SERVICE_HOST','localhost') |
      | port      | yaks:env('MAIL_SERVICE_PORT','22222') |
      | username  | test |
      | password  | secret |
      | email     | user@demo.org |
      | to        | announcements@demo.org |
      | subject   | Kamelet workshop |
      | message   | Camel K rocks |

  Scenario: Create mail server
    Given HTTP server "mail-server"
    Given HTTP server listening on port 22222
    Given create Kubernetes service mail-server with port mapping 25:22222
    And stop HTTP server
    Given load endpoint mail-server.groovy

  Scenario: Create Camel K resources
    Given load Pipe timer-to-mail.yaml
    And Camel K integration timer-to-mail should be running
    And Camel K integration timer-to-mail should print Routes startup

  Scenario: Verify mail message sent
    Then endpoint mail-server should receive body
    """
    {
      "from": "${email}",
      "to": "${to}",
      "cc": "",
      "bcc": "",
      "replyTo": "@ignore@",
      "subject": "${subject}",
      "body": {
        "contentType": "text/plain",
        "content": "${message}",
        "attachments": null
      }
    }
    """

  Scenario: Remove Camel K resources
    Given delete Pipe timer-to-mail
    And delete Kubernetes service mail-server
