/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import junit.framework.TestSuite;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.core.Customer;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestUseBeanTag
extends BaseJellyTest {
    public TestUseBeanTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestUseBeanTag.class);
    }

    public void testSimple() throws Exception {
        this.setUpScript("testUseBeanTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.simple", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestUseBeanTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestUseBeanTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestUseBeanTag.assertEquals((String)"name not set", (String)"testing", (String)customer.getName());
        TestUseBeanTag.assertEquals((String)"city not set", (String)"sydney", (String)customer.getCity());
    }

    public void testExtension() throws Exception {
        this.setUpScript("testUseBeanTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.extension", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestUseBeanTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestUseBeanTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestUseBeanTag.assertNull((String)"name set wrongly", (Object)customer.getName());
        TestUseBeanTag.assertEquals((String)"city not set", (String)"sydney", (String)customer.getCity());
    }

    public void testBadProperty() throws Exception {
        this.setUpScript("testUseBeanTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.badProperty", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        Exception e = (Exception)this.getJellyContext().getVariable("ex");
        TestUseBeanTag.assertNotNull((String)"Should have failed to set invalid bean property", (Object)e);
    }

    public void testIgnoredBadProperty() throws Exception {
        this.setUpScript("testUseBeanTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.badPropertyIgnored", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestUseBeanTag.assertNotNull((String)"Should have ignored invalid bean property", (Object)customer);
    }
}

