/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.jelly.tags.jetty;

/**
 * Respond to a PUT request to a Jetty http server
 *
 * @author  rtl
 * @version $Id: PutRequestTag.java 1807933 2017-09-09 21:37:10Z chtompki $
 */
/** A tag for the http PUT method */
public class PutRequestTag extends AbstractMethodHandlerTag {

    /** return the name of the http method handled by this tag */
    public String getMethodHandled() {
        return "PUT";
    }
}

