/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Path;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class SCXMLHelper {
    private static final String NAMESPACES_KEY = "_ALL_NAMESPACES";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$commons$scxml$SCXMLHelper;

    public static boolean isStringEmpty(String attr) {
        return attr == null || attr.trim().length() == 0;
    }

    public static boolean isDescendant(TransitionTarget tt, TransitionTarget ctx) {
        for (TransitionTarget parent = tt.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != ctx) continue;
            return true;
        }
        return false;
    }

    public static Set getAncestorClosure(Set states, Set upperBounds) {
        HashSet<TransitionTarget> closure = new HashSet<TransitionTarget>(states.size() * 2);
        Iterator i = states.iterator();
        while (i.hasNext()) {
            for (TransitionTarget tt = (TransitionTarget)i.next(); tt != null && closure.add(tt) && (upperBounds == null || !upperBounds.contains(tt)); tt = tt.getParent()) {
            }
        }
        return closure;
    }

    public static boolean isLegalConfig(Set states, ErrorReporter errRep) {
        boolean legalConfig = true;
        IdentityHashMap<TransitionTarget, HashSet<TransitionTarget>> counts = new IdentityHashMap<TransitionTarget, HashSet<TransitionTarget>>();
        HashSet<TransitionTarget> scxmlCount = new HashSet<TransitionTarget>();
        Iterator<Object> i = states.iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)i.next();
            TransitionTarget parent = null;
            while ((parent = tt.getParent()) != null) {
                HashSet<TransitionTarget> cnt = (HashSet<TransitionTarget>)counts.get(parent);
                if (cnt == null) {
                    cnt = new HashSet<TransitionTarget>();
                    counts.put(parent, cnt);
                }
                cnt.add(tt);
                tt = parent;
            }
            scxmlCount.add(tt);
        }
        i = counts.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            TransitionTarget tt = (TransitionTarget)entry.getKey();
            Set count = (Set)entry.getValue();
            if (tt instanceof Parallel) {
                Parallel p = (Parallel)tt;
                if (count.size() < p.getChildren().size()) {
                    errRep.onError("ILLEGAL_CONFIG", "Not all AND states active for parallel " + p.getId(), entry);
                    legalConfig = false;
                }
            } else if (count.size() > 1) {
                errRep.onError("ILLEGAL_CONFIG", "Multiple OR states active for state " + tt.getId(), entry);
                legalConfig = false;
            }
            count.clear();
        }
        if (scxmlCount.size() > 1) {
            errRep.onError("ILLEGAL_CONFIG", "Multiple top-level OR states active!", scxmlCount);
        }
        scxmlCount.clear();
        counts.clear();
        return legalConfig;
    }

    public static TransitionTarget getLCA(TransitionTarget tt1, TransitionTarget tt2) {
        if (tt1 == tt2) {
            return tt1;
        }
        if (SCXMLHelper.isDescendant(tt1, tt2)) {
            return tt2;
        }
        if (SCXMLHelper.isDescendant(tt2, tt1)) {
            return tt1;
        }
        HashSet<TransitionTarget> parents = new HashSet<TransitionTarget>();
        TransitionTarget tmp = tt1;
        while ((tmp = tmp.getParent()) != null) {
            parents.add(tmp);
        }
        tmp = tt2;
        while ((tmp = tmp.getParent()) != null) {
            if (parents.add(tmp)) continue;
            parents.clear();
            return tmp;
        }
        return null;
    }

    public static Set getStatesExited(Transition t, Set currentStates) {
        HashSet<TransitionTarget> allStates = new HashSet<TransitionTarget>();
        if (t.getTargets().size() == 0) {
            return allStates;
        }
        Path p = (Path)t.getPaths().get(0);
        allStates.addAll(p.getUpwardSegment());
        TransitionTarget source = t.getParent();
        Iterator act = currentStates.iterator();
        while (act.hasNext()) {
            TransitionTarget a = (TransitionTarget)act.next();
            if (!SCXMLHelper.isDescendant(a, source)) continue;
            boolean added = false;
            added = allStates.add(a);
            while (added && a != source) {
                a = a.getParent();
                added = allStates.add(a);
            }
        }
        if (p.isCrossRegion()) {
            Iterator regions = p.getRegionsExited().iterator();
            while (regions.hasNext()) {
                Parallel par = (Parallel)((State)regions.next()).getParent();
                Iterator siblings = par.getChildren().iterator();
                while (siblings.hasNext()) {
                    State s = (State)siblings.next();
                    Iterator act2 = currentStates.iterator();
                    while (act2.hasNext()) {
                        TransitionTarget a = (TransitionTarget)act2.next();
                        if (!SCXMLHelper.isDescendant(a, s)) continue;
                        boolean added = false;
                        added = allStates.add(a);
                        while (added && a != s) {
                            a = a.getParent();
                            added = allStates.add(a);
                        }
                    }
                }
            }
        }
        return allStates;
    }

    public static boolean inConflict(Transition t1, Transition t2, Set currentStates) {
        Set ts1 = SCXMLHelper.getStatesExited(t1, currentStates);
        Set ts2 = SCXMLHelper.getStatesExited(t2, currentStates);
        ts1.retainAll(ts2);
        return !ts1.isEmpty();
    }

    public static boolean subtypeOf(Class child, Class parent) {
        if (child == null || parent == null) {
            return false;
        }
        for (Class current = child; current != (class$java$lang$Object == null ? SCXMLHelper.class$("java.lang.Object") : class$java$lang$Object); current = current.getSuperclass()) {
            if (current != parent) continue;
            return true;
        }
        return false;
    }

    public static boolean implementationOf(Class clas, Class interfayce) {
        if (clas == null || interfayce == null || !interfayce.isInterface()) {
            return false;
        }
        for (Class current = clas; current != (class$java$lang$Object == null ? SCXMLHelper.class$("java.lang.Object") : class$java$lang$Object); current = current.getSuperclass()) {
            Class<?>[] implementedInterfaces = current.getInterfaces();
            for (int i = 0; i < implementedInterfaces.length; ++i) {
                if (implementedInterfaces[i] != interfayce) continue;
                return true;
            }
        }
        return false;
    }

    public static void setNodeValue(Node node, String value) {
        switch (node.getNodeType()) {
            case 2: {
                node.setNodeValue(value);
                break;
            }
            case 1: {
                if (node.hasChildNodes()) {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 3) continue;
                        node.removeChild(child);
                    }
                }
                Text txt = node.getOwnerDocument().createTextNode(value);
                node.appendChild(txt);
                break;
            }
            case 3: 
            case 4: {
                ((CharacterData)node).setData(value);
                break;
            }
            default: {
                String err = "Trying to set value of a strange Node type: " + node.getNodeType();
                throw new IllegalArgumentException(err);
            }
        }
    }

    public static String getNodeValue(Node node) {
        String result = "";
        if (node == null) {
            return result;
        }
        switch (node.getNodeType()) {
            case 2: {
                result = node.getNodeValue();
                break;
            }
            case 1: {
                if (!node.hasChildNodes()) break;
                StringBuffer buf = new StringBuffer();
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 3) continue;
                    buf.append(((CharacterData)child).getData());
                }
                result = buf.toString();
                break;
            }
            case 3: 
            case 4: {
                result = ((CharacterData)node).getData();
                break;
            }
            default: {
                String err = "Trying to get value of a strange Node type: " + node.getNodeType();
                throw new IllegalArgumentException(err);
            }
        }
        return result.trim();
    }

    public static void cloneDatamodel(Datamodel datamodel, Context ctx, Evaluator evaluator, Log log) {
        if (datamodel == null) {
            return;
        }
        List data = datamodel.getData();
        if (data == null) {
            return;
        }
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Data datum = (Data)iter.next();
            Node datumNode = datum.getNode();
            Node valueNode = null;
            if (datumNode != null) {
                valueNode = datumNode.cloneNode(true);
            }
            if (!SCXMLHelper.isStringEmpty(datum.getSrc())) {
                ctx.setLocal(datum.getId(), valueNode);
                continue;
            }
            if (!SCXMLHelper.isStringEmpty(datum.getExpr())) {
                Object value = null;
                try {
                    ctx.setLocal(NAMESPACES_KEY, datum.getNamespaces());
                    value = evaluator.eval(ctx, datum.getExpr());
                    ctx.setLocal(NAMESPACES_KEY, null);
                }
                catch (SCXMLExpressionException see) {
                    if (log != null) {
                        log.error((Object)see.getMessage(), (Throwable)see);
                    }
                    Log defaultLog = LogFactory.getLog((Class)(class$org$apache$commons$scxml$SCXMLHelper == null ? SCXMLHelper.class$("org.apache.commons.scxml.SCXMLHelper") : class$org$apache$commons$scxml$SCXMLHelper));
                    defaultLog.error((Object)see.getMessage(), (Throwable)see);
                }
                ctx.setLocal(datum.getId(), value);
                continue;
            }
            ctx.setLocal(datum.getId(), valueNode);
        }
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringWriter stringWriter = new StringWriter(len + 8);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String entityName = null;
            switch (c) {
                case '\"': {
                    entityName = "quot";
                    break;
                }
                case '&': {
                    entityName = "amp";
                    break;
                }
                case '\'': {
                    entityName = "apos";
                    break;
                }
                case '<': {
                    entityName = "lt";
                    break;
                }
                case '>': {
                    entityName = "gt";
                    break;
                }
            }
            if (entityName == null) {
                if (c > '\u007f') {
                    stringWriter.write("&#");
                    stringWriter.write(Integer.toString(c));
                    stringWriter.write(59);
                    continue;
                }
                stringWriter.write(c);
                continue;
            }
            stringWriter.write(38);
            stringWriter.write(entityName);
            stringWriter.write(59);
        }
        return stringWriter.toString();
    }

    private SCXMLHelper() {
    }
}

