/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class Lister {
    private static final ArchiveStreamFactory FACTORY = ArchiveStreamFactory.DEFAULT;

    private static <T extends ArchiveInputStream<? extends E>, E extends ArchiveEntry> T createArchiveInputStream(String[] args, InputStream inputStream) throws ArchiveException {
        if (args.length > 1) {
            return (T)FACTORY.createArchiveInputStream(args[1], inputStream);
        }
        return (T)FACTORY.createArchiveInputStream(inputStream);
    }

    private static String detectFormat(File file) throws ArchiveException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            String string = ArchiveStreamFactory.detect(inputStream);
            return string;
        }
    }

    private static void list7z(File file) throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(file);){
            SevenZArchiveEntry entry;
            System.out.println("Created " + sevenZFile);
            while ((entry = sevenZFile.getNextEntry()) != null) {
                String name = entry.getName() == null ? sevenZFile.getDefaultName() + " (entry name was null)" : entry.getName();
                System.out.println(name);
            }
        }
    }

    private static void listStream(File file, String[] args) throws ArchiveException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
             Object archiveInputStream = Lister.createArchiveInputStream(args, inputStream);){
            Object entry;
            System.out.println("Created " + archiveInputStream.toString());
            while ((entry = ((ArchiveInputStream)archiveInputStream).getNextEntry()) != null) {
                System.out.println(entry.getName());
            }
        }
    }

    private static void listZipUsingTarFile(File file) throws IOException {
        try (TarFile tarFile = new TarFile(file);){
            System.out.println("Created " + tarFile);
            tarFile.getEntries().forEach(en -> System.out.println(en.getName()));
        }
    }

    private static void listZipUsingZipFile(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            System.out.println("Created " + zipFile);
            Enumeration<ZipArchiveEntry> en = zipFile.getEntries();
            while (en.hasMoreElements()) {
                System.out.println(en.nextElement().getName());
            }
        }
    }

    public static void main(String[] args) throws ArchiveException, IOException {
        String format;
        if (args == null || args.length == 0) {
            Lister.usage();
            return;
        }
        Objects.requireNonNull(args[0], "args[0]");
        System.out.println("Analysing " + args[0]);
        File file = new File(args[0]);
        if (!file.isFile()) {
            System.err.println(file + " doesn't exist or is a directory");
        }
        String string = format = args.length > 1 ? args[1] : Lister.detectFormat(file);
        if ("7z".equalsIgnoreCase(format)) {
            Lister.list7z(file);
        } else if ("zipfile".equals(format)) {
            Lister.listZipUsingZipFile(file);
        } else if ("tarfile".equals(format)) {
            Lister.listZipUsingTarFile(file);
        } else {
            Lister.listStream(file, args);
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]\n");
        System.out.println("The magic archive-type 'zipfile' prefers ZipFile over ZipArchiveInputStream");
        System.out.println("The magic archive-type 'tarfile' prefers TarFile over TarArchiveInputStream");
    }
}

