/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.analysis.matchers.AbstractSimpleMatcher;

public class CopyrightMatcher
extends AbstractSimpleMatcher {
    private static final String COPYRIGHT_SYMBOL_DEFN = "\\([Cc]\\)|\u00a9";
    private static final String COPYRIGHT_PATTERN_DEFN = "(\\b)?\\([Cc]\\)|\u00a9|Copyright\\b";
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(\\b)?\\([Cc]\\)|\u00a9|Copyright\\b");
    private static final String ONE_PART = "\\s+((\\([Cc]\\)|\u00a9)\\s+)?%s";
    private static final String TWO_PART = "\\s+((\\([Cc]\\)|\u00a9)\\s+)?%s,?\\s+%s";
    private final Pattern dateOwnerPattern;
    private final Pattern ownerDatePattern;

    public CopyrightMatcher(String start, String stop, String owner) {
        this(null, start, stop, owner);
    }

    public CopyrightMatcher(String id, String start, String stop, String owner) {
        super(id);
        String dateDefn = "";
        if (StringUtils.isNotEmpty(start)) {
            dateDefn = StringUtils.isNotEmpty(stop) ? String.format("%s\\s*-\\s*%s", start.trim(), stop.trim()) : start.trim();
        }
        if (StringUtils.isEmpty(owner)) {
            if (StringUtils.isEmpty(dateDefn)) {
                dateDefn = "[0-9]{4}";
            }
            this.dateOwnerPattern = Pattern.compile(String.format(ONE_PART, dateDefn));
            this.ownerDatePattern = null;
        } else if (StringUtils.isEmpty(dateDefn)) {
            this.dateOwnerPattern = Pattern.compile(String.format(ONE_PART, owner));
            this.ownerDatePattern = null;
        } else {
            this.dateOwnerPattern = Pattern.compile(String.format(TWO_PART, dateDefn, owner));
            this.ownerDatePattern = Pattern.compile(String.format(TWO_PART, owner, dateDefn));
        }
    }

    @Override
    protected boolean doMatch(String line) {
        Matcher matcher;
        String lowerLine = line.toLowerCase();
        if ((lowerLine.contains("copyright") || lowerLine.contains("(c)") || line.contains("\u00a9")) && (matcher = COPYRIGHT_PATTERN.matcher(line)).find()) {
            String buffer = line.substring(matcher.end());
            if ((matcher = this.dateOwnerPattern.matcher(buffer)).find() && matcher.start() == 0) {
                return true;
            }
            if (this.ownerDatePattern != null) {
                matcher = this.ownerDatePattern.matcher(buffer);
                return matcher.find() && matcher.start() == 0;
            }
        }
        return false;
    }
}

