/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import org.apache.rat.utils.Log;

public class DefaultLog
implements Log {
    public static final DefaultLog INSTANCE = new DefaultLog();
    private Log.Level level = Log.Level.WARN;

    private DefaultLog() {
    }

    public void setLevel(Log.Level level) {
        this.level = level;
    }

    public Log.Level getLevel() {
        return this.level;
    }

    @Override
    public void log(Log.Level level, String msg) {
        if (this.level.ordinal() <= level.ordinal()) {
            switch (level) {
                case DEBUG: 
                case INFO: 
                case WARN: {
                    System.out.format("%s: %s%n", new Object[]{level, msg});
                    break;
                }
                case ERROR: {
                    System.err.format("%s: %s%n", new Object[]{level, msg});
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }
    }
}

