/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseFamilySetFactory;
import org.apache.rat.license.SimpleLicense;

public interface ILicense
extends IHeaderMatcher,
Comparable<ILicense> {
    public ILicenseFamily getLicenseFamily();

    public String getNotes();

    public String derivedFrom();

    public String getName();

    public static Builder builder() {
        return new Builder();
    }

    public static Comparator<ILicense> getComparator() {
        return Comparator.comparing(IHeaderMatcher::getId);
    }

    public static class Builder {
        private IHeaderMatcher.Builder matcher;
        private String notes;
        private String derivedFrom;
        private String name;
        private String id;
        private final ILicenseFamily.Builder licenseFamily = ILicenseFamily.builder();

        public Builder setMatcher(IHeaderMatcher.Builder matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder setMatcher(IHeaderMatcher matcher) {
            this.matcher = () -> matcher;
            return this;
        }

        public Builder setNotes(String notes) {
            this.notes = notes;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDerivedFrom(String derivedFrom) {
            this.derivedFrom = derivedFrom;
            return this;
        }

        public Builder setLicenseFamilyCategory(String licenseFamilyCategory) {
            this.licenseFamily.setLicenseFamilyCategory(licenseFamilyCategory);
            this.licenseFamily.setLicenseFamilyName("License Family for searching");
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public ILicense build(SortedSet<ILicenseFamily> licenseFamilies) {
            Objects.requireNonNull(this.matcher, "Matcher must not be null");
            ILicenseFamily family = LicenseFamilySetFactory.search(this.licenseFamily.build(), licenseFamilies);
            Objects.requireNonNull(family, "License family " + this.licenseFamily.getCategory() + " not found.");
            return new SimpleLicense(family, this.matcher.build(), this.derivedFrom, this.notes, this.name, this.id);
        }
    }
}

