/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseFamilySetFactory;

public class DefaultPolicy
implements IDocumentAnalyser {
    private final SortedSet<ILicenseFamily> approvedLicenseFamilies = LicenseFamilySetFactory.emptyLicenseFamilySet();

    public DefaultPolicy(Collection<ILicenseFamily> approvedLicenseFamilies) {
        this.approvedLicenseFamilies.addAll(approvedLicenseFamilies);
    }

    public void add(ILicenseFamily approvedLicense) {
        this.approvedLicenseFamilies.add(approvedLicense);
    }

    @Override
    public void analyse(Document document) {
        if (document != null && document.getMetaData().value("http://org/apache/rat/meta-data#HeaderCategory") != null) {
            ILicenseFamily licenseFamily = ILicenseFamily.builder().setLicenseFamilyCategory(document.getMetaData().value("http://org/apache/rat/meta-data#HeaderCategory")).setLicenseFamilyName(document.getMetaData().value("http://org/apache/rat/meta-data#LicenseFamilyName")).build();
            boolean approval = this.approvedLicenseFamilies.contains(licenseFamily);
            this.reportLicenseApprovalClaim(document, approval);
        }
    }

    public void reportLicenseApprovalClaim(Document document, boolean isAcceptable) {
        document.getMetaData().set(isAcceptable ? MetaData.RAT_APPROVED_LICENSE_DATUM_TRUE : MetaData.RAT_APPROVED_LICENSE_DATUM_FALSE);
    }

    public SortedSet<ILicenseFamily> getApprovedLicenseNames() {
        return Collections.unmodifiableSortedSet(this.approvedLicenseFamilies);
    }
}

