/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.util;

import java.io.File;
import java.io.IOException;
import org.apache.rat.annotation.AbstractLicenseAppender;
import org.apache.rat.annotation.ApacheV2LicenseAppender;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.report.AbstractReport;
import org.apache.rat.utils.Log;

public class LicenseAddingReport
extends AbstractReport {
    private final AbstractLicenseAppender appender;

    public LicenseAddingReport(Log log, String pCopyrightMsg, boolean pForced) {
        this.appender = pCopyrightMsg == null ? new ApacheV2LicenseAppender(log) : new ApacheV2LicenseAppender(log, pCopyrightMsg);
        this.appender.setForce(pForced);
    }

    @Override
    public void report(Document document) throws RatException {
        File file;
        MetaData.Datum licenseHeader = document.getMetaData().get("http://org/apache/rat/meta-data#HeaderCategory");
        if ((licenseHeader == null || MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_UNKNOWN.getValue().equals(licenseHeader.getValue())) && (file = new File(document.getName())).isFile()) {
            try {
                this.appender.append(file);
            }
            catch (IOException e) {
                throw new RatException(e.getMessage(), e);
            }
        }
    }
}

