/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.IOException;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.apache.commons.jcs3.utils.zip.CompressionUtil;

public class CompressingSerializer
extends StandardSerializer {
    private final IElementSerializer serializer;

    public CompressingSerializer() {
        this(new StandardSerializer());
    }

    public CompressingSerializer(IElementSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public <T> byte[] serialize(T obj) throws IOException {
        byte[] uncompressed = this.serializer.serialize(obj);
        return CompressionUtil.compressByteArray(uncompressed);
    }

    @Override
    public <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (data == null) {
            return null;
        }
        byte[] decompressedByteArray = CompressionUtil.decompressByteArray(data);
        return this.serializer.deSerialize(decompressedByteArray, loader);
    }
}

