/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package router

import (
	"github.com/apache/dubbo-go/common"
	"github.com/apache/dubbo-go/protocol"
)

// Chain
type Chain interface {
	Route(*common.URL, protocol.Invocation) []protocol.Invoker
	// Refresh invokers
	SetInvokers([]protocol.Invoker)
	// AddRouters Add routers
	AddRouters([]PriorityRouter)
	// GetNotifyChan get notify channel of this chain
	GetNotifyChan() chan struct{}
	// Detect Route State
	DetectRoute() (RouteSnapshot, error)
	// listens on events to update the address cache
	Loop()
}

// RouteSnapshot is the snapshot of Route
type RouteSnapshot struct {
	Invokers       []protocol.Invoker
	RouteSnapshots []string
}

// nolint
func (rs *RouteSnapshot) AddRouteSnapshot(msg string) {
	rs.RouteSnapshots = append(rs.RouteSnapshots, msg)
}
