/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateDecoder
extends ActionScriptDecoder {
    @Override
    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        Date result = null;
        if (java.sql.Date.class.isAssignableFrom(desiredClass)) {
            if (encodedObject instanceof Date) {
                Date date = (Date)encodedObject;
                result = new java.sql.Date(date.getTime());
            } else if (encodedObject instanceof Calendar) {
                Calendar calendar = (Calendar)encodedObject;
                result = new java.sql.Date(calendar.getTimeInMillis());
            } else if (encodedObject instanceof Number) {
                Number number = (Number)encodedObject;
                result = new java.sql.Date(number.longValue());
            }
        } else if (Timestamp.class.isAssignableFrom(desiredClass)) {
            if (encodedObject instanceof Date) {
                Date date = (Date)encodedObject;
                result = new Timestamp(date.getTime());
            } else if (encodedObject instanceof Calendar) {
                Calendar calendar = (Calendar)encodedObject;
                result = new Timestamp(calendar.getTimeInMillis());
            } else if (encodedObject instanceof Number) {
                Number number = (Number)encodedObject;
                result = new Timestamp(number.longValue());
            }
        } else if (Time.class.isAssignableFrom(desiredClass)) {
            if (encodedObject instanceof Date) {
                Date date = (Date)encodedObject;
                result = new Time(date.getTime());
            } else if (encodedObject instanceof Calendar) {
                Calendar calendar = (Calendar)encodedObject;
                result = new Time(calendar.getTimeInMillis());
            } else if (encodedObject instanceof Number) {
                Number number = (Number)encodedObject;
                result = new Time(number.longValue());
            }
        } else if (Date.class.isAssignableFrom(desiredClass)) {
            if (encodedObject instanceof Date) {
                result = (Date)encodedObject;
            } else if (encodedObject instanceof Calendar) {
                Calendar calendar = (Calendar)encodedObject;
                result = calendar.getTime();
            } else if (encodedObject instanceof Number) {
                Number number = (Number)encodedObject;
                result = new Date(number.longValue());
            }
        }
        if (result == null) {
            DecoderFactory.invalidType(encodedObject, desiredClass);
        }
        return result;
    }
}

