/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.MessageException;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.ResourceLoader;

public class SecurityException
extends MessageException {
    static final long serialVersionUID = -3168212117963624230L;
    public static final String CLIENT_AUTHENTICATION_CODE = "Client.Authentication";
    public static final String CLIENT_AUTHORIZATION_CODE = "Client.Authorization";
    public static final String SERVER_AUTHENTICATION_CODE = "Server.Authentication";
    public static final String SERVER_AUTHORIZATION_CODE = "Server.Authorization";
    private Message failingMessage;

    public SecurityException() {
    }

    public SecurityException(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    public String getDefaultLogMessageIntro() {
        return "Security error for message: ";
    }

    @Override
    public boolean isLogStackTraceEnabled() {
        return false;
    }

    @Override
    public short getPreferredLogLevel() {
        return 2;
    }

    public Message getFailingMessage() {
        return this.failingMessage;
    }

    public void setFailingMessage(Message failingMessage) {
        this.failingMessage = failingMessage;
    }

    @Override
    public ErrorMessage createErrorMessage() {
        ErrorMessage msg = super.createErrorMessage();
        if (this.failingMessage != null) {
            msg.setCorrelationId(this.failingMessage.getMessageId());
            msg.setDestination(this.failingMessage.getDestination());
        }
        return msg;
    }
}

