/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export class NoticeRule {
  id!: number;
  name!: string;
  receiverId!: number[];
  receiverName!: string[];
  templateId!: number | null;
  templateName!: string | null;
  enable: boolean = true;
  // forward all or not
  filterAll: boolean = true;
  // filter alert level
  priorities!: number[];
  tags!: TagItem[];
  days!: number[];
  periodStart!: Date;
  periodEnd!: Date;
  creator!: string;
  modifier!: string;
  gmtCreate!: number;
  gmtUpdate!: number;
}

export class TagItem {
  name!: string;
  value!: string;
}
