/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.server.lock;

import org.apache.seata.core.store.DefaultDistributedLocker;
import org.apache.seata.core.store.DistributedLocker;
import org.apache.seata.server.lock.distributed.DistributedLockerFactory;
import org.apache.seata.server.storage.redis.lock.RedisDistributedLocker;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @description Distributed locker factory test
 */
@SpringBootTest
public class DistributedLockerFactoryTest {

    @BeforeEach
    public void setUp() {
        DistributedLockerFactory.cleanLocker();
    }

    @Test
    public void testGetDistributedLockerNotSupport() {
        DistributedLocker es = DistributedLockerFactory.getDistributedLocker("es");
        Assertions.assertEquals(es.getClass(), DefaultDistributedLocker.class);
    }

    @Test
    public void testGetDistributedLocker() {
        DistributedLocker redis = DistributedLockerFactory.getDistributedLocker("redis");
        Assertions.assertEquals(redis.getClass(), RedisDistributedLocker.class);
    }

    @AfterEach
    public void tearDown() {
        DistributedLockerFactory.cleanLocker();
    }
}
