/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.internal;

import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class TypeAwareDecoder {
    protected Type type;

    public TypeAwareDecoder() {
    }

    public TypeAwareDecoder(Type type) {
        this.type = type;
    }

    protected void init(EndpointConfig endpointConfig) {
        if (this.type != null) {
            return;
        }
        if (ServerEndpointConfig.class.isInstance(endpointConfig)) {
            Class endpointClass = ((ServerEndpointConfig)ServerEndpointConfig.class.cast(endpointConfig)).getEndpointClass();
            block0: for (Method m : endpointClass.getMethods()) {
                if (Object.class == m.getDeclaringClass() || m.getAnnotation(OnMessage.class) == null) continue;
                Type[] genericParameterTypes = m.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    if (genericParameterTypes[i] == Session.class) continue;
                    boolean param = false;
                    for (Annotation a : m.getParameterAnnotations()[i]) {
                        if (PathParam.class != a.annotationType()) continue;
                        param = true;
                        break;
                    }
                    if (param) continue;
                    this.type = genericParameterTypes[i];
                    break block0;
                }
                break;
            }
            if (this.type == null) {
                throw new IllegalArgumentException("didn't find @OnMessage in " + endpointClass);
            }
        } else {
            this.type = (Type)Type.class.cast(endpointConfig.getUserProperties().get("johnzon.websocket.message.type"));
            if (this.type == null) {
                throw new IllegalArgumentException("didn't find johnzon.websocket.message.type");
            }
        }
    }
}

