/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.internal;

public class JsonPointerTracker {
    public static final JsonPointerTracker ROOT = new JsonPointerTracker(null, null);
    private final JsonPointerTracker parent;
    private final String currentNode;
    private String jsonPointer;

    public JsonPointerTracker(JsonPointerTracker parent, String currentNode) {
        this.parent = parent;
        this.currentNode = currentNode;
    }

    public JsonPointerTracker(JsonPointerTracker jsonPointer, int i) {
        this(jsonPointer, Integer.toString(i));
    }

    public String toString() {
        if (this.jsonPointer != null) {
            return this.jsonPointer;
        }
        if (this.parent != null) {
            this.jsonPointer = (String)(this.parent != ROOT ? this.parent + "/" : "/") + JsonPointerTracker.encode(this.currentNode);
            return this.jsonPointer;
        }
        if (this.currentNode != null) {
            this.jsonPointer = "/" + JsonPointerTracker.encode(this.currentNode);
            return this.jsonPointer;
        }
        this.jsonPointer = "/";
        return "/";
    }

    private static String encode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return JsonPointerTracker.replace(JsonPointerTracker.replace(s, "~", "~0"), "/", "~1");
    }

    private static String replace(String src, String from, String to) {
        if (src.isEmpty()) {
            return src;
        }
        int start = src.indexOf(from);
        if (start >= 0) {
            return src.substring(0, start) + to + JsonPointerTracker.replace(src.substring(start + from.length()), from, to);
        }
        return src;
    }
}

