/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.ParamTree;
import com.sun.source.util.DocTrees;
import javax.lang.model.element.Element;
import org.apache.logging.log4j.docgen.processor.AbstractAsciiDocTreeVisitor;
import org.apache.logging.log4j.docgen.processor.AsciiDocData;
import org.apache.logging.log4j.docgen.processor.ElementImports;
import org.jspecify.annotations.Nullable;

final class AsciiDocConverter {
    private final DocTrees docTrees;
    private final DocTreeVisitor<Void, AsciiDocData> docCommentTreeVisitor;
    private final DocTreeVisitor<Void, AsciiDocData> paramTreeVisitor;

    AsciiDocConverter(DocTrees docTrees) {
        this.docTrees = docTrees;
        this.docCommentTreeVisitor = new DocCommentTreeVisitor();
        this.paramTreeVisitor = new ParamTreeVisitor();
    }

    public @Nullable String toAsciiDoc(Element element, ElementImports imports, String qualifiedClassName) {
        DocCommentTree tree = this.docTrees.getDocCommentTree(element);
        if (tree == null) {
            return null;
        }
        AsciiDocData data = new AsciiDocData(imports, qualifiedClassName);
        tree.accept(this.docCommentTreeVisitor, data);
        return data.getDocument().convert();
    }

    public String toAsciiDoc(ParamTree tree, ElementImports imports, String qualifiedClassName) {
        AsciiDocData data = new AsciiDocData(imports, qualifiedClassName);
        tree.accept(this.paramTreeVisitor, data);
        return data.getDocument().convert();
    }

    private static final class DocCommentTreeVisitor
    extends AbstractAsciiDocTreeVisitor {
        private DocCommentTreeVisitor() {
        }

        @Override
        public Void visitDocComment(DocCommentTree node, AsciiDocData data) {
            for (DocTree docTree : node.getFirstSentence()) {
                docTree.accept(this, data);
            }
            data.newParagraph();
            for (DocTree docTree : node.getBody()) {
                docTree.accept(this, data);
            }
            data.newParagraph();
            return (Void)super.visitDocComment(node, data);
        }
    }

    private static final class ParamTreeVisitor
    extends AbstractAsciiDocTreeVisitor {
        private ParamTreeVisitor() {
        }

        @Override
        public Void visitParam(ParamTree node, AsciiDocData data) {
            for (DocTree docTree : node.getDescription()) {
                docTree.accept(this, data);
            }
            data.newParagraph();
            return (Void)super.visitParam(node, data);
        }
    }
}

