/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.test.async.BlockingAppender;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.junit.UsingStatusListener;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;

@Tag(value="async")
@UsingStatusListener
@Timeout(value=5L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
public abstract class QueueFullAbstractTest {
    protected static boolean TRACE = Boolean.getBoolean(QueueFullAbstractTest.class.getSimpleName() + ".TRACE");
    protected BlockingAppender blockingAppender;
    protected Unlocker unlocker;
    protected static final String APPENDER_NAME = "Blocking";
    protected static final int BUFFER_COUNT = 128;
    protected static final int MESSAGE_COUNT = 130;
    protected static final Logger LOGGER = StatusLogger.getLogger();

    protected void testNormalQueueFullKeepsMessagesInOrder(LoggerContext ctx, BlockingAppender blockingAppender) throws Exception {
        this.checkConfig(ctx);
        ExtendedLogger logger = ctx.getLogger(this.getClass());
        blockingAppender.countDownLatch = new CountDownLatch(1);
        Unlocker unlocker = new Unlocker(new CountDownLatch(129), blockingAppender);
        unlocker.start();
        this.asyncTest((Logger)logger, unlocker, blockingAppender);
        unlocker.join();
    }

    protected abstract void checkConfig(LoggerContext var1) throws Exception;

    protected void asyncTest(Logger logger, Unlocker unlocker, BlockingAppender blockingAppender) {
        for (int i = 0; i < 130; ++i) {
            LOGGER.info("Test logging message {}. Ring buffer capacity was {}, countdown latch was {}.", (Object)i, (Object)this.asyncRemainingCapacity(logger), (Object)unlocker.countDownLatch.getCount());
            unlocker.countDownLatch.countDown();
            String param = "I'm innocent";
            logger.info("Logging innocent object #{}: {}", (Object)i, (Object)"I'm innocent");
        }
        LOGGER.info("Waiting for message delivery: blockingAppender.logEvents.count={}.", (Object)blockingAppender.logEvents.size());
        while (blockingAppender.logEvents.size() < 130) {
            Thread.yield();
        }
        LOGGER.info("All {} message have been delivered: blockingAppender.logEvents.count={}.", (Object)130, (Object)blockingAppender.logEvents.size());
        Stack<String> actual = QueueFullAbstractTest.transform(blockingAppender.logEvents);
        for (int i = 0; i < 130; ++i) {
            Assertions.assertThat((String)actual.pop()).isEqualTo("Logging innocent object #%d: I'm innocent", new Object[]{i});
        }
        Assertions.assertThat(actual).isEmpty();
    }

    static Stack<String> transform(List<LogEvent> logEvents) {
        List<String> filtered = QueueFullAbstractTest.getMessages(logEvents);
        Collections.reverse(filtered);
        Stack<String> result = new Stack<String>();
        result.addAll(filtered);
        return result;
    }

    static List<String> getMessages(List<LogEvent> logEvents) {
        ArrayList<String> filtered = new ArrayList<String>(logEvents.size());
        for (LogEvent event : logEvents) {
            filtered.add(event.getMessage().getFormattedMessage());
        }
        return filtered;
    }

    protected long asyncRemainingCapacity(Logger logger) {
        LoggerConfig loggerConfig = ((org.apache.logging.log4j.core.Logger)logger).get();
        Appender async = (Appender)loggerConfig.getAppenders().get("async");
        if (async instanceof AsyncAppender) {
            return ((AsyncAppender)async).getQueueCapacity();
        }
        throw new IllegalStateException("Neither Async Loggers nor AsyncAppender are configured");
    }

    protected static void assertAsyncAppender(LoggerContext ctx) {
        Configuration config = ctx.getConfiguration();
        Assertions.assertThat((Object)config).isNotNull();
        Collection appenders = config.getRootLogger().getAppenders().values();
        ((AbstractCollectionAssert)Assertions.assertThat(appenders).hasSize(1)).allMatch(AsyncAppender.class::isInstance);
    }

    protected static void assertFormatMessagesInBackground() {
        Assertions.assertThat((boolean)Constants.FORMAT_MESSAGES_IN_BACKGROUND).isTrue();
    }

    protected static class Unlocker
    extends Thread {
        public final CountDownLatch countDownLatch;
        final BlockingAppender blockingAppender;

        public Unlocker(CountDownLatch countDownLatch, BlockingAppender blockingAppender) {
            this.countDownLatch = countDownLatch;
            this.blockingAppender = blockingAppender;
        }

        @Override
        public void run() {
            try {
                this.countDownLatch.await();
                LOGGER.info("Unlocker activated. Sleeping 500 millis before taking action...");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("Unlocker signalling BlockingAppender to proceed...");
            this.blockingAppender.countDownLatch.countDown();
        }
    }
}

