/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import aQute.bnd.annotation.spi.ServiceConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ServiceLoader;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.internal.JulLevelPropagator;
import org.apache.logging.log4j.jul.internal.LevelConverter;
import org.apache.logging.log4j.jul.spi.LevelChangePropagator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

@ServiceConsumer(value=LevelChangePropagator.class, cardinality="single")
public class Log4jBridgeHandler
extends Handler {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final Formatter julFormatter = new SimpleFormatter();
    private String julSuffixToAppend = null;
    private LevelChangePropagator levelPropagator;
    private volatile boolean installAsLevelPropagator = false;

    public static void install(boolean removeHandlersForRootLogger, String suffixToAppend, boolean propagateLevels) {
        java.util.logging.Logger rootLogger = Log4jBridgeHandler.getJulRootLogger();
        if (removeHandlersForRootLogger) {
            for (Handler hdl : rootLogger.getHandlers()) {
                rootLogger.removeHandler(hdl);
            }
        }
        rootLogger.addHandler(new Log4jBridgeHandler(suffixToAppend, propagateLevels));
    }

    private static java.util.logging.Logger getJulRootLogger() {
        return java.util.logging.LogManager.getLogManager().getLogger("");
    }

    public Log4jBridgeHandler() {
        java.util.logging.LogManager julLogMgr = java.util.logging.LogManager.getLogManager();
        String className = this.getClass().getName();
        this.configure(julLogMgr.getProperty(className + ".appendSuffix"), Boolean.parseBoolean(julLogMgr.getProperty(className + ".propagateLevels")));
    }

    private Log4jBridgeHandler(String suffixToAppend, boolean propagateLevels) {
        this.configure(suffixToAppend, propagateLevels);
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="The data is available only in debug mode.")
    private void configure(String suffixToAppend, boolean propagateLevels) {
        if (suffixToAppend != null) {
            if (((String)(suffixToAppend = ((String)suffixToAppend).trim())).isEmpty()) {
                suffixToAppend = null;
            } else if (((String)suffixToAppend).charAt(0) != '.') {
                suffixToAppend = "." + (String)suffixToAppend;
            }
        }
        this.julSuffixToAppend = suffixToAppend;
        this.installAsLevelPropagator = propagateLevels;
        if (this.installAsLevelPropagator) {
            this.levelPropagator = ServiceLoaderUtil.safeStream(LevelChangePropagator.class, ServiceLoader.load(LevelChangePropagator.class, this.getClass().getClassLoader()), (Logger)LOGGER).findAny().orElse(JulLevelPropagator.INSTANCE);
        }
        LOGGER.debug("Log4jBridgeHandler init. with: suffix='{}', lvlProp={}, instance={}", suffixToAppend, (Object)propagateLevels, (Object)this);
    }

    @Override
    public void close() {
        if (this.levelPropagator != null) {
            this.levelPropagator.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (this.installAsLevelPropagator) {
            Log4jBridgeHandler log4jBridgeHandler = this;
            synchronized (log4jBridgeHandler) {
                if (this.installAsLevelPropagator) {
                    this.levelPropagator.start();
                    this.installAsLevelPropagator = false;
                }
            }
        }
        Logger log4jLogger = this.getLog4jLogger(record);
        String msg = julFormatter.formatMessage(record);
        Level log4jLevel = LevelConverter.toLog4jLevel(record.getLevel());
        Throwable thrown = record.getThrown();
        if (log4jLogger instanceof ExtendedLogger) {
            try {
                ((ExtendedLogger)log4jLogger).logIfEnabled(FQCN, log4jLevel, null, msg, thrown);
            }
            catch (NoClassDefFoundError e) {
                log4jLogger.warn("Log4jBridgeHandler: ignored exception when calling 'ExtendedLogger': {}", (Object)e.toString());
                log4jLogger.log(log4jLevel, msg, thrown);
            }
        } else {
            log4jLogger.log(log4jLevel, msg, thrown);
        }
    }

    @Override
    public void flush() {
    }

    private Logger getLog4jLogger(LogRecord record) {
        Object name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        } else if (this.julSuffixToAppend != null) {
            name = (String)name + this.julSuffixToAppend;
        }
        return LogManager.getLogger((String)name);
    }
}

