/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jndi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.jndi.JndiProperties;
import org.apache.logging.log4j.jndi.internal.JndiCloser;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;

public class JndiManager
extends AbstractManager {
    private static final JndiManagerFactory FACTORY = new JndiManagerFactory();
    private static final String JAVA_SCHEME = "java";
    private static final JndiProperties props = (JndiProperties)PropertyEnvironment.getGlobal().getProperty(JndiProperties.class);
    private final Context context;

    public static boolean isJndiEnabled() {
        return JndiManager.isJndiContextSelectorEnabled() || JndiManager.isJndiJdbcEnabled() || JndiManager.isJndiJmsEnabled() || JndiManager.isJndiLookupEnabled();
    }

    public static boolean isJndiContextSelectorEnabled() {
        return props.enableContextSelector();
    }

    public static boolean isJndiJmsEnabled() {
        return props.enableJms();
    }

    public static boolean isJndiLookupEnabled() {
        return props.enableLookup();
    }

    public static boolean isJndiJdbcEnabled() {
        return props.enableJdbc();
    }

    private JndiManager(String name, Context context) {
        super(null, name);
        this.context = context;
    }

    public static JndiManager getDefaultManager() {
        return (JndiManager)JndiManager.getManager((String)JndiManager.class.getName(), (ManagerFactory)FACTORY, null);
    }

    public static JndiManager getDefaultManager(String name) {
        return (JndiManager)JndiManager.getManager((String)name, (ManagerFactory)FACTORY, null);
    }

    public static JndiManager getJndiManager(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        Properties properties = JndiManager.createProperties(initialContextFactoryName, providerURL, urlPkgPrefixes, securityPrincipal, securityCredentials, additionalProperties);
        return (JndiManager)JndiManager.getManager((String)JndiManager.createManagerName(), (ManagerFactory)FACTORY, (Object)properties);
    }

    public static JndiManager getJndiManager(Properties properties) {
        return (JndiManager)JndiManager.getManager((String)JndiManager.createManagerName(), (ManagerFactory)FACTORY, (Object)properties);
    }

    private static String createManagerName() {
        return JndiManager.class.getName() + "@" + JndiManager.class.hashCode();
    }

    public static Properties createProperties(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        if (initialContextFactoryName == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", initialContextFactoryName);
        if (providerURL != null) {
            properties.setProperty("java.naming.provider.url", providerURL);
        } else {
            LOGGER.warn("The JNDI InitialContextFactory class name [{}] was provided, but there was no associated provider URL. This is likely to cause problems.", (Object)initialContextFactoryName);
        }
        if (urlPkgPrefixes != null) {
            properties.setProperty("java.naming.factory.url.pkgs", urlPkgPrefixes);
        }
        if (securityPrincipal != null) {
            properties.setProperty("java.naming.security.principal", securityPrincipal);
            if (securityCredentials != null) {
                properties.setProperty("java.naming.security.credentials", securityCredentials);
            } else {
                LOGGER.warn("A security principal [{}] was provided, but with no corresponding security credentials.", (Object)securityPrincipal);
            }
        }
        if (additionalProperties != null) {
            properties.putAll((Map<?, ?>)additionalProperties);
        }
        return properties;
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return JndiCloser.closeSilently(this.context);
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="This method only accepts an empty or 'java:' URI scheme.")
    public <T> T lookup(String name) throws NamingException {
        if (this.context == null) {
            return null;
        }
        try {
            URI uri = new URI(name);
            if (uri.getScheme() == null || uri.getScheme().equals(JAVA_SCHEME)) {
                return (T)this.context.lookup(name);
            }
            LOGGER.warn("Unsupported JNDI URI - {}", (Object)name);
        }
        catch (URISyntaxException ex) {
            LOGGER.warn("Invalid JNDI URI - {}", (Object)name);
        }
        return null;
    }

    public String toString() {
        return "JndiManager [context=" + this.context + ", count=" + this.count + "]";
    }

    private static class JndiManagerFactory
    implements ManagerFactory<JndiManager, Properties> {
        private JndiManagerFactory() {
        }

        public JndiManager createManager(String name, Properties data) {
            if (!JndiManager.isJndiEnabled()) {
                throw new IllegalStateException(String.format("JNDI must be enabled by setting one of the %s* properties to true", "JNDI.enable{SubKey}"));
            }
            try {
                return new JndiManager(name, new InitialContext(data));
            }
            catch (NamingException e) {
                LOGGER.error("Error creating JNDI InitialContext for '{}'.", (Object)name, (Object)e);
                return null;
            }
        }
    }
}

