/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jndi.lookup;

import java.util.Objects;
import javax.naming.NamingException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.core.lookup.Lookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.jndi.JndiManager;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;

@Lookup
@Plugin(value="jndi")
public final class JndiLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker((String)"LOOKUP");
    static final String CONTAINER_JNDI_RESOURCE_PATH_PREFIX = "java:comp/env/";

    @Factory
    public static StrLookup createLookup() {
        if (JndiManager.isJndiLookupEnabled()) {
            return new JndiLookup();
        }
        LOGGER.error("Ignoring request to use JNDI lookup. JNDI must be enabled by setting log4j.enableJndiLookup=true");
        return null;
    }

    private JndiLookup() {
    }

    public String lookup(LogEvent ignored, String key) {
        String string;
        block9: {
            if (key == null) {
                return null;
            }
            String jndiName = this.convertJndiName(key);
            JndiManager jndiManager = JndiManager.getDefaultManager();
            try {
                string = Objects.toString(jndiManager.lookup(jndiName), null);
                if (jndiManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jndiManager != null) {
                        try {
                            jndiManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NamingException e) {
                    LOGGER.warn(LOOKUP, "Error looking up JNDI resource [{}].", (Object)jndiName, (Object)e);
                    return null;
                }
            }
            jndiManager.close();
        }
        return string;
    }

    private String convertJndiName(String jndiName) {
        if (!jndiName.startsWith(CONTAINER_JNDI_RESOURCE_PATH_PREFIX) && jndiName.indexOf(58) == -1) {
            return CONTAINER_JNDI_RESOURCE_PATH_PREFIX + jndiName;
        }
        return jndiName;
    }
}

