/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.DefaultErrorHandler;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

public abstract class AbstractAppender
extends AbstractFilterable
implements Appender {
    private final String name;
    private final boolean ignoreExceptions;
    private final Layout layout;
    private volatile ErrorHandler handler = new DefaultErrorHandler(this);

    protected AbstractAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, Property[] properties) {
        super(filter, properties);
        this.name = Objects.requireNonNull(name, "name");
        this.layout = layout;
        this.ignoreExceptions = ignoreExceptions;
    }

    public static int parseInt(String s, int defaultValue) {
        try {
            return Integers.parseInt(s, defaultValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse \"{}\" as an integer,  using default value {}: {}", (Object)s, (Object)defaultValue, (Object)e);
            return defaultValue;
        }
    }

    @Override
    public boolean requiresLocation() {
        return this.layout != null && this.layout.requiresLocation();
    }

    public void error(String msg) {
        this.handler.error(msg);
    }

    public void error(String msg, LogEvent event, Throwable t) {
        this.handler.error(msg, event, t);
    }

    public void error(String msg, Throwable t) {
        this.handler.error(msg, t);
    }

    @Override
    public ErrorHandler getHandler() {
        return this.handler;
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean ignoreExceptions() {
        return this.ignoreExceptions;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
        if (handler == null) {
            LOGGER.error("The handler cannot be set to null");
            return;
        }
        this.handler = handler;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B> {
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        private Layout layout;
        private String name;
        private Configuration configuration;

        public String getName() {
            return this.name;
        }

        public boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public Layout getLayout() {
            return this.layout;
        }

        public B setName(@PluginAttribute @Required(message="No appender name provided") String name) {
            this.name = name;
            return (B)((Builder)this.asBuilder());
        }

        public B setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return (B)((Builder)this.asBuilder());
        }

        public B setLayout(@PluginElement Layout layout) {
            this.layout = layout;
            return (B)((Builder)this.asBuilder());
        }

        public Layout getOrCreateLayout() {
            if (this.layout == null) {
                return PatternLayout.createDefaultLayout(this.getConfiguration());
            }
            return this.layout;
        }

        public Layout getOrCreateLayout(Charset charset) {
            if (this.layout == null) {
                return PatternLayout.newBuilder().setConfiguration(this.getConfiguration()).setCharset(charset).build();
            }
            return this.layout;
        }

        @Inject
        public B setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return (B)((Builder)this.asBuilder());
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

