/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.Service;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Model;

/**
 * Provides the super POM that all models implicitly inherit from.
 */
@Experimental
public interface SuperPomProvider extends Service {

    /**
     * Gets the super POM for the specified model version.
     *
     * @param version The model version to retrieve the super POM for (e.g. "4.0.0"), must not be {@code null}.
     * @return The super POM, never {@code null}.
     * @throws SuperPomProviderException if the super POM could not be retrieved
     */
    @Nonnull
    Model getSuperPom(@Nonnull String version);
}
