/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;

/**
 * Attach a POM to an artifact.
 *
 */
@Deprecated
public class ProjectArtifactMetadata extends AbstractArtifactMetadata {
    private final File file;

    public ProjectArtifactMetadata(Artifact artifact) {
        this(artifact, null);
    }

    public ProjectArtifactMetadata(Artifact artifact, File file) {
        super(artifact);
        this.file = file;
    }

    public File getFile() {
        return file;
    }

    public String getRemoteFilename() {
        return getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return getFilename();
    }

    private String getFilename() {
        return getArtifactId() + "-" + artifact.getVersion() + ".pom";
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository)
            throws RepositoryMetadataStoreException {
        File destination = new File(
                localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(this, remoteRepository));

        // ----------------------------------------------------------------------------
        // I'm fully aware that the file could just be moved using File.rename but
        // there are bugs in various JVM that have problems doing this across
        // different filesystem. So we'll incur the small hit to actually copy
        // here and be safe. jvz.
        // ----------------------------------------------------------------------------

        try {
            Files.createDirectories(destination.toPath().getParent());
            Files.copy(file.toPath(), destination.toPath());
        } catch (IOException e) {
            throw new RepositoryMetadataStoreException("Error copying POM to the local repository.", e);
        }
    }

    public String toString() {
        return "project information for " + artifact.getArtifactId() + " " + artifact.getVersion();
    }

    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String getBaseVersion() {
        return artifact.getBaseVersion();
    }

    public Object getKey() {
        return "project " + artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public void merge(ArtifactMetadata metadata) {
        ProjectArtifactMetadata m = (ProjectArtifactMetadata) metadata;
        if (!m.file.equals(file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + getKey());
        }
    }

    public void merge(org.apache.maven.repository.legacy.metadata.ArtifactMetadata metadata) {
        this.merge((ArtifactMetadata) metadata);
    }
}
