/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Utility methods for configuring the behaviour of a JSF-based Orchestra installation.
 * 
 * @since 1.1
 */
public abstract class ConfigUtils
{
    private static final String RH_KEY = ConfigUtils.class.getName() + ".RH";

    static List getRequestHandlers(Map reqScope)
    {
        List rhl = (List) reqScope.get(RH_KEY);
        if (rhl != null)
        {
            return rhl;
        }
        else
        {
            return Collections.EMPTY_LIST;
        }
    }

    /**
     * Can be called from a Filter or similar class in order to registed a
     * handler that should be run at the start of each request just
     * <i>after</i> the FacesContext object has been created, and at the end
     * of each request just <i>before</i> the FacesContext is released.
     */
    public static void registerRequestHandler(Map reqScope, RequestHandler rh)
    {
        List rhl = (List) reqScope.get(RH_KEY);
        if (rhl == null)
        {
            rhl = new ArrayList(1);
            reqScope.put(RH_KEY, rhl);
        }
        rhl.add(rh);
    }
}
