/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package javax.portlet.faces;

import javax.faces.FacesException;

/**
 * Thrown when the bridge's <code>doFacesRequest</code> method is called
 * and the bridge is in an uninitialized state.
 */

public class BridgeUninitializedException extends BridgeException
{
  //TODO: Update to use static serialVersionUID ala other exceptions
  //   when we figure out how to get maven to generate.

  public BridgeUninitializedException()
  {
    super();
  }

  public BridgeUninitializedException(String message)
  {
    super(message);
  }

  public BridgeUninitializedException(String message, Throwable cause)
  {
    super(message, cause);
  }

  public BridgeUninitializedException(Throwable cause)
  {
    super(cause);
  }
}
