/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler.webapp.config;

import javax.faces.context.FacesContext;

import org.apache.myfaces.commons.resourcehandler.webapp.config.impl.WebConfigProviderImpl;

/**
 * 
 * @author Leonardo Uribe
 *
 */
public abstract class WebConfigProviderFactory
{
    protected static final String FACTORY_DEFAULT = WebConfigProviderFactory.class.getName();

    private static final String FACTORY_KEY = WebConfigProviderFactory.class.getName();

    public static WebConfigProviderFactory getFacesConfigResourceProviderFactory(FacesContext ctx)
    {
        WebConfigProviderFactory instance = (WebConfigProviderFactory) ctx.getExternalContext().getApplicationMap().get(FACTORY_KEY);
        if (instance != null)
        {
            return instance;
        }
        else
        {
            WebConfigProviderFactory wcpf = new WebConfigProviderFactory()
            {
                @Override
                public WebConfigProvider createWebConfigProvider(FacesContext facesContext)
                {
                    return new WebConfigProviderImpl();
                }
            };
            setWebConfigProviderFactory(ctx, wcpf);
            return wcpf;
        }
    }

    public static void setWebConfigProviderFactory(FacesContext ctx, WebConfigProviderFactory instance)
    {
        ctx.getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract WebConfigProvider createWebConfigProvider(FacesContext facesContext);
}
