/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy.impl;

import org.apache.portals.applications.webcontent.proxy.SSOSiteCredentials;

public class DefaultSSOSiteCredentials implements SSOSiteCredentials
{
    
    private static final long serialVersionUID = 1L;
    
    private String baseURL;
    private String host;
    private int port = -1;
    private String realm;
    private String scheme;
    
    private String username;
    private String password;
    
    private boolean challengeResponseAuthentication = true;
    private boolean formAuthentication = false;
    private String formUserField;
    private String formPwdField;
    
    public DefaultSSOSiteCredentials()
    {
        this(null);
    }
    
    public DefaultSSOSiteCredentials(String baseURL)
    {
        this(baseURL, null);
    }
    
    public DefaultSSOSiteCredentials(String baseURL, String host)
    {
        this(baseURL, host, -1);
    }
    
    public DefaultSSOSiteCredentials(String baseURL, String host, int port)
    {
        this(baseURL, host, port, null);
    }
    
    public DefaultSSOSiteCredentials(String baseURL, String host, int port, String realm)
    {
        this.baseURL = baseURL;
        this.host = host;
        this.port = port;
        this.realm = realm;
    }
    
    public String getBaseURL()
    {
        return baseURL;
    }
    
    public void setBaseURL(String baseURL)
    {
        this.baseURL = baseURL;
    }
    
    public String getHost()
    {
        return host;
    }
    
    public void setHost(String host)
    {
        this.host = host;
    }

    public int getPort()
    {
        return port;
    }
    
    public void setPort(int port)
    {
        this.port = port;
    }

    public String getRealm()
    {
        return realm;
    }
    
    public void setRealm(String realm)
    {
        this.realm = realm;
    }

    public String getScheme()
    {
        return scheme;
    }
    
    public void setScheme(String scheme)
    {
        this.scheme = scheme;
    }

    public String getUsername()
    {
        return username;
    }
    
    public void setUsername(String username)
    {
        this.username = username;
    }
    
    public String getPassword()
    {
        return password;
    }
    
    public void setPassword(String password)
    {
        this.password = password;
    }
    
    public boolean isChallengeResponseAuthentication()
    {
        return challengeResponseAuthentication;
    }
    
    public void setChallengeResponseAuthentication(boolean challengeResponseAuthentication)
    {
        this.challengeResponseAuthentication = challengeResponseAuthentication;
    }
    
    public boolean isFormAuthentication()
    {
        return formAuthentication;
    }
    
    public void setFormAuthentication(boolean formAuthentication)
    {
        this.formAuthentication = formAuthentication;
    }
    
    public String getFormUserField()
    {
        return formUserField;
    }
    
    public void setFormUserField(String formUserField)
    {
        this.formUserField = formUserField;
    }

    public String getFormPwdField()
    {
        return formPwdField;
    }
    
    public void setFormPwdField(String formPwdField)
    {
        this.formPwdField = formPwdField;
    }
    
}
