/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.util;

import javax.swing.text.Segment;

/**
 * CharArraySegment
 * <P>
 * Implements {@link CharSequence} interface by leveraging {@link Segment} class.
 * </P>
 * <P>
 * <EM>
 * Note: Since Java 1.6, {@link Segment} implements {@link CharSequence} interface.
 * </EM>
 * </P>
 * 
 * @version $Id: CharArraySegment.java 821006 2009-10-02 13:09:00Z woonsan $
 */
public class CharArraySegment extends Segment implements CharSequence
{
    
    public CharArraySegment()
    {
        super();
    }

    public CharArraySegment(char[] array, int offset, int count)
    {
        super(array, offset, count);
    }

    public CharArraySegment(String s)
    {
        super(s.toCharArray(), 0, s.length());
    }

    public char charAt(int index)
    {
        if (index < 0 || index >= count)
        {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        
        return array[offset + index];
    }

    public int length()
    {
        return count;
    }

    public CharSequence subSequence(int start, int end)
    {
        if (start < 0)
        {
            throw new IllegalArgumentException("Invalid start index: " + start);
        }
        
        if (end > count)
        {
            throw new IllegalArgumentException("Invalid end index: " + end);
        }
        
        if (start > end)
        {
            throw new IllegalArgumentException("Invalid start and end index: " + start + " > " + end);
        }
        
        CharArraySegment charArraySegment = new CharArraySegment();
        
        charArraySegment.array = array;
        charArraySegment.offset = offset + start;
        charArraySegment.count = end - start;
        
        return charArraySegment;
    }
    
}
