/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.facade;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;

public final class CloudJobFacade
implements JobFacade {
    private final ShardingContexts shardingContexts;
    private final JobConfiguration jobConfig;
    private final JobTracingEventBus jobTracingEventBus;

    public JobConfiguration loadJobConfiguration(boolean fromCache) {
        JobConfiguration result = JobConfiguration.newBuilder((String)this.jobConfig.getJobName(), (int)this.jobConfig.getShardingTotalCount()).cron(this.jobConfig.getCron()).shardingItemParameters(this.jobConfig.getShardingItemParameters()).jobParameter(this.jobConfig.getJobParameter()).failover(this.jobConfig.isFailover()).misfire(this.jobConfig.isMisfire()).description(this.jobConfig.getDescription()).jobExecutorServiceHandlerType(this.jobConfig.getJobExecutorServiceHandlerType()).jobErrorHandlerType(this.jobConfig.getJobErrorHandlerType()).build();
        result.getProps().putAll((Map<?, ?>)this.jobConfig.getProps());
        return result;
    }

    public void checkJobExecutionEnvironment() {
    }

    public void failoverIfNecessary() {
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
    }

    public ShardingContexts getShardingContexts() {
        return this.shardingContexts;
    }

    public boolean misfireIfRunning(Collection<Integer> shardingItems) {
        return false;
    }

    public void clearMisfire(Collection<Integer> shardingItems) {
    }

    public boolean isExecuteMisfired(Collection<Integer> shardingItems) {
        return false;
    }

    public boolean isNeedSharding() {
        return false;
    }

    public void beforeJobExecuted(ShardingContexts shardingContexts) {
    }

    public void afterJobExecuted(ShardingContexts shardingContexts) {
    }

    public void postJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        this.jobTracingEventBus.post((JobEvent)jobExecutionEvent);
    }

    public void postJobStatusTraceEvent(String taskId, JobStatusTraceEvent.State state, String message) {
        TaskContext taskContext = TaskContext.from((String)taskId);
        this.jobTracingEventBus.post((JobEvent)new JobStatusTraceEvent(taskContext.getMetaInfo().getJobName(), taskContext.getId(), taskContext.getSlaveId(), JobStatusTraceEvent.Source.CLOUD_EXECUTOR, taskContext.getType().toString(), String.valueOf(taskContext.getMetaInfo().getShardingItems()), state, message));
    }

    @Generated
    public CloudJobFacade(ShardingContexts shardingContexts, JobConfiguration jobConfig, JobTracingEventBus jobTracingEventBus) {
        this.shardingContexts = shardingContexts;
        this.jobConfig = jobConfig;
        this.jobTracingEventBus = jobTracingEventBus;
    }
}

