Apache SkyWalking BanyanDB Helm Chart
==========


![](https://github.com/apache/skywalking-banyandb-helm/workflows/Build/badge.svg?branch=master)

BanyanDB, as an observability database, aims to ingest, analyze, and store Metrics, Tracing, and Logging data.
It's designed to handle observability data generated by observability platforms and APM systems, like [Apache SkyWalking](https://github.com/apache/skywalking) etc.

BanyanDB Helm Chart repository provides ways to install and configure BanyanDB running in a cluster natively on Kubernetes. The scripts are written in Helm 3.

# Chart Detailed Configuration

## Introduction

This chart bootstraps an Apache Skywalking BanyanDB deployment on a [Kubernetes](http://kubernetes.io) cluster using the [Helm](https://helm.sh) package manager.
The released versions of the helm chart can be found on [Docker Hub](https://hub.docker.com/r/apache/skywalking-banyandb-helm).

## Prerequisites

 - Kubernetes 1.24.0+
 - Helm 3

## Installing the Chart

To install the chart with the release name `my-release`:

```shell
$ helm install my-release banyandb -n <namespace>
```

The command deploys BanyanDB on the Kubernetes cluster with the default configuration. The [configuration](#configuration) section lists the parameters that can be configured during installation.

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```shell
$ helm uninstall my-release -n <namespace>
```

The command removes all the banyandb components associated with the chart and deletes the release.

## Compatibility

The chart needs the minimum version of BanyanDB 0.7.0 when the chart version is 0.3.0 or higher.

## Configuration

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| cluster.data.affinity | object | `{}` | Affinity settings for pod assignment |
| cluster.data.podAffinityPreset | string | `""` | podAffinityPreset Pod affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.data.podAntiAffinityPreset | string | `""` | podAntiAffinityPreset Pod anti-affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.data.env | list | `[]` | Environment variables for the data pods |
| cluster.data.grpcSvc.annotations | object | `{}` | Annotations for the gRPC service |
| cluster.data.grpcSvc.labels | object | `{}` | Labels for the gRPC service |
| cluster.data.grpcSvc.port | int | `17912` | Port for the gRPC service |
| cluster.data.livenessProbe.initialDelaySeconds | int | `20` | Initial delay before starting liveness probes |
| cluster.data.livenessProbe.periodSeconds | int | `30` | Period between liveness probes |
| cluster.data.livenessProbe.timeoutSeconds | int | `5` | Timeout for liveness probes |
| cluster.data.livenessProbe.successThreshold | int | `1` | Success threshold for liveness probes |
| cluster.data.livenessProbe.failureThreshold | int | `5` | Failure threshold for liveness probes |
| cluster.data.nodeSelector | list | `[]` | Node selector for data pods |
| cluster.data.podAnnotations | string | `nil` | Annotations for the data pods |
| cluster.data.podDisruptionBudget | object | `{}` | Pod disruption budget for data pods |
| cluster.data.priorityClassName | string | `""` | Priority class name for data pods |
| cluster.data.readinessProbe.initialDelaySeconds | int | `20` | Initial delay before starting readiness probes |
| cluster.data.readinessProbe.periodSeconds | int | `10` | Period between readiness probes |
| cluster.data.readinessProbe.timeoutSeconds | int | `5` | Timeout for readiness probes |
| cluster.data.readinessProbe.successThreshold | int | `1` | Success threshold for readiness probes |
| cluster.data.readinessProbe.failureThreshold | int | `5` | Failure threshold for readiness probes |
| cluster.data.replicas | int | `3` | Number of replicas for data pods |
| cluster.data.resources.limits | list | `[]` | Resource limits for data pods |
| cluster.data.resources.requests | list | `[]` | Resource requests for data pods |
| cluster.data.securityContext | object | `{}` | Security context for data pods |
| cluster.data.sidecar | list | `[]` | Sidecar containers for data pods |
| cluster.data.tolerations | list | `[]` | Tolerations for data pods |
| cluster.enabled | bool | `true` | Enable or disable the cluster |
| cluster.etcdEndpoints | list | `[]` | Endpoints for the etcd cluster |
| cluster.liaison.affinity | object | `{}` | Affinity settings for liaison pods |
| cluster.liaison.podAffinityPreset | string | `""` | podAffinityPreset Pod affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.liaison.podAntiAffinityPreset | string | `""` | podAntiAffinityPreset Pod anti-affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.liaison.env | list | `[]` | Environment variables for the liaison pods |
| cluster.liaison.grpcSvc.annotations | object | `{}` | Annotations for the gRPC service |
| cluster.liaison.grpcSvc.labels | object | `{}` | Labels for the gRPC service |
| cluster.liaison.grpcSvc.port | int | `17912` | Port for the gRPC service |
| cluster.liaison.httpSvc.annotations | object | `{}` | Annotations for the HTTP service |
| cluster.liaison.httpSvc.externalIPs | list | `[]` | External IPs for the HTTP service |
| cluster.liaison.httpSvc.labels | object | `{}` | Labels for the HTTP service |
| cluster.liaison.httpSvc.loadBalancerIP | string | `nil` | Load balancer IP for the HTTP service |
| cluster.liaison.httpSvc.loadBalancerSourceRanges | list | `[]` | Load balancer source ranges for the HTTP service |
| cluster.liaison.httpSvc.port | int | `17913` | Port for the HTTP service |
| cluster.liaison.httpSvc.type | string | `"LoadBalancer"` | Type of the HTTP service |
| cluster.liaison.ingress.annotations | object | `{}` | Annotations for the ingress |
| cluster.liaison.ingress.enabled | bool | `false` | Enable or disable the ingress |
| cluster.liaison.ingress.labels | object | `{}` | Labels for the ingress |
| cluster.liaison.ingress.rules | list | `[]` | Rules for the ingress |
| cluster.liaison.ingress.tls | list | `[]` | TLS settings for the ingress |
| cluster.liaison.livenessProbe.initialDelaySeconds | int | `20` | Initial delay before starting liveness probes |
| cluster.liaison.livenessProbe.periodSeconds | int | `30` | Period between liveness probes |
| cluster.liaison.livenessProbe.timeoutSeconds | int | `5` | Timeout for liveness probes |
| cluster.liaison.livenessProbe.successThreshold | int | `1` | Success threshold for liveness probes |
| cluster.liaison.livenessProbe.failureThreshold | int | `5` | Failure threshold for liveness probes |
| cluster.liaison.nodeSelector | list | `[]` | Node selector for liaison pods |
| cluster.liaison.podAnnotations | string | `nil` | Annotations for the liaison pods |
| cluster.liaison.podDisruptionBudget | object | `{}` | Pod disruption budget for liaison pods |
| cluster.liaison.priorityClassName | string | `""` | Priority class name for liaison pods |
| cluster.liaison.readinessProbe.initialDelaySeconds | int | `20` | Initial delay before starting readiness probes |
| cluster.liaison.readinessProbe.periodSeconds | int | `10` | Period between readiness probes |
| cluster.liaison.readinessProbe.timeoutSeconds | int | `5` | Timeout for readiness probes |
| cluster.liaison.readinessProbe.successThreshold | int | `1` | Success threshold for readiness probes |
| cluster.liaison.readinessProbe.failureThreshold | int | `5` | Failure threshold for readiness probes |
| cluster.liaison.replicas | int | `2` | Number of replicas for liaison pods |
| cluster.liaison.resources.limits | list | `[]` | Resource limits for liaison pods |
| cluster.liaison.resources.requests | list | `[]` | Resource requests for liaison pods |
| cluster.liaison.securityContext | object | `{}` | Security context for liaison pods |
| cluster.liaison.tolerations | list | `[]` | Tolerations for liaison pods |
| cluster.ui.type | string | `"Embedded"` | Type of the UI deployment: `None`, `Embedded`, `Standalone` |
| cluster.ui.standalone.affinity | object | `{}` | Affinity settings for standalone UI pods |
| cluster.ui.standalone.podAffinityPreset | string | `""` | podAffinityPreset Pod affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.ui.standalone.podAntiAffinityPreset | string | `""` | podAntiAffinityPreset Pod anti-affinity preset. Ignored if `affinity` is set. Allowed values: `soft` or `hard`  |
| cluster.ui.standalone.env | list | `[]` | Environment variables for the standalone UI pods |
| cluster.ui.standalone.httpSvc.annotations | object | `{}` | Annotations for the HTTP service |
| cluster.ui.standalone.httpSvc.externalIPs | list | `[]` | External IPs for the HTTP service |
| cluster.ui.standalone.httpSvc.labels | object | `{}` | Labels for the HTTP service |
| cluster.ui.standalone.httpSvc.loadBalancerIP | string | `nil` | Load balancer IP for the HTTP service |
| cluster.ui.standalone.httpSvc.loadBalancerSourceRanges | list | `[]` | Load balancer source ranges for the HTTP service |
| cluster.ui.standalone.httpSvc.port | int | `17913` | Port for the HTTP service |
| cluster.ui.standalone.httpSvc.type | string | `"LoadBalancer"` | Type of the HTTP service |
| cluster.ui.standalone.ingress.annotations | object | `{}` | Annotations for the ingress |
| cluster.ui.standalone.ingress.enabled | bool | `false` | Enable or disable the ingress |
| cluster.ui.standalone.ingress.labels | object | `{}` | Labels for the ingress |
| cluster.ui.standalone.ingress.rules | list | `[]` | Rules for the ingress |
| cluster.ui.standalone.ingress.tls | list | `[]` | TLS settings for the ingress |
| cluster.ui.standalone.livenessProbe.initialDelaySeconds | int | `20` | Initial delay before starting liveness probes |
| cluster.ui.standalone.livenessProbe.periodSeconds | int | `30` | Period between liveness probes |
| cluster.ui.standalone.livenessProbe.timeoutSeconds | int | `5` | Timeout for liveness probes |
| cluster.ui.standalone.livenessProbe.successThreshold | int | `1` | Success threshold for liveness probes |
| cluster.ui.standalone.livenessProbe.failureThreshold | int | `5` | Failure threshold for liveness probes |
| cluster.ui.standalone.nodeSelector | list | `[]` | Node selector for UI standalone pods |
| cluster.ui.standalone.podAnnotations | string | `nil` | Annotations for the UI standalone pods |
| cluster.ui.standalone.podDisruptionBudget | object | `{}` | Pod disruption budget for UI standalone pods |
| cluster.ui.standalone.priorityClassName | string | `""` | Priority class name for UI standalone pods |
| cluster.ui.standalone.readinessProbe.initialDelaySeconds | int | `20` | Initial delay before starting readiness probes |
| cluster.ui.standalone.readinessProbe.periodSeconds | int | `10` | Period between readiness probes |
| cluster.ui.standalone.readinessProbe.timeoutSeconds | int | `5` | Timeout for readiness probes |
| cluster.ui.standalone.readinessProbe.successThreshold | int | `1` | Success threshold for readiness probes |
| cluster.ui.standalone.readinessProbe.failureThreshold | int | `5` | Failure threshold for readiness probes |
| cluster.ui.standalone.replicas | int | `2` | Number of replicas for UI standalone pods |
| cluster.ui.standalone.resources.limits | list | `[]` | Resource limits for UI standalone pods |
| cluster.ui.standalone.resources.requests | list | `[]` | Resource requests for UI standalone pods |
| cluster.ui.standalone.securityContext | object | `{}` | Security context for UI standalone pods |
| cluster.ui.standalone.tolerations | list | `[]` | Tolerations for UI standalone pods |
| etcd.auth.client.caFilename | string | `""` | CA filename for etcd client authentication |
| etcd.auth.client.certFilename | string | `"tls.crt"` | Certificate filename for etcd client authentication |
| etcd.auth.client.certKeyFilename | string | `"tls.key"` | Certificate key filename for etcd client authentication |
| etcd.auth.client.enableAuthentication | bool | `false` | Enable or disable etcd client authentication |
| etcd.auth.client.existingSecret | string | `""` | Existing secret for etcd client authentication |
| etcd.auth.client.secureTransport | bool | `false` | Enable or disable secure transport for etcd client |
| etcd.auth.rbac.allowNoneAuthentication | bool | `false` | Allow none authentication for etcd RBAC |
| etcd.auth.rbac.create | bool | `true` | Create etcd RBAC resources |
| etcd.auth.rbac.rootPassword | string | `"banyandb"` | Root password for etcd RBAC |
| etcd.enabled | bool | `true` | Enable or disable etcd |
| etcd.livenessProbe.initialDelaySeconds | int | `10` | Initial delay before starting liveness probes |
| etcd.readinessProbe.initialDelaySeconds | int | `10` | Initial delay before starting readiness probes |
| etcd.replicaCount | int | `1` | Number of replicas for etcd |
| fullnameOverride | string | `""` | Full name override for the chart |
| nameOverride | string | `"banyandb"` | Name override for the chart |
| image.pullPolicy | string | `"IfNotPresent"` | Image pull policy |
| image.repository | string | `"docker.io/apache/skywalking-banyandb"` | Image repository |
| image.tag | string | `"0.7.0-rc0"` | Image tag |
| serviceAccount.annotations | object | `{}` | Annotations for the service account |
| serviceAccount.create | bool | `true` | Create a service account |
| serviceAccount.name | string | `""` | Name of the service account |
| standalone.affinity | object | `{}` | Affinity settings for standalone pods |
| standalone.enabled | bool | `false` | Enable or disable standalone mode |
| standalone.env | list | `[]` | Environment variables for standalone pods |
| standalone.grpcSvc.annotations | object | `{}` | Annotations for the gRPC service |
| standalone.grpcSvc.labels | object | `{}` | Labels for the gRPC service |
| standalone.grpcSvc.port | int | `17912` | Port for the gRPC service |
| standalone.httpSvc.annotations | object | `{}` | Annotations for the HTTP service |
| standalone.httpSvc.externalIPs | list | `[]` | External IPs for the HTTP service |
| standalone.httpSvc.labels | object | `{}` | Labels for the HTTP service |
| standalone.httpSvc.loadBalancerIP | string | `nil` | Load balancer IP for the HTTP service |
| standalone.httpSvc.loadBalancerSourceRanges | list | `[]` | Load balancer source ranges for the HTTP service |
| standalone.httpSvc.port | int | `17913` | Port for the HTTP service |
| standalone.httpSvc.type | string | `"LoadBalancer"` | Type of the HTTP service |
| standalone.ingress.annotations | object | `{}` | Annotations for the ingress |
| standalone.ingress.enabled | bool | `false` | Enable or disable the ingress |
| standalone.ingress.labels | object | `{}` | Labels for the ingress |
| standalone.ingress.rules | list | `[]` | Rules for the ingress |
| standalone.ingress.tls | list | `[]` | TLS settings for the ingress |
| standalone.livenessProbe.initialDelaySeconds | int | `20` | Initial delay before starting liveness probes |
| standalone.livenessProbe.periodSeconds | int | `30` | Period between liveness probes |
| standalone.livenessProbe.timeoutSeconds | int | `5` | Timeout for liveness probes |
| standalone.livenessProbe.successThreshold | int | `1` | Success threshold for liveness probes |
| standalone.livenessProbe.failureThreshold | int | `5` | Failure threshold for liveness probes |
| standalone.nodeSelector | list | `[]` | Node selector for standalone pods |
| standalone.podAnnotations.example | string | `"banyandb-foo"` | Example annotation for standalone pods |
| standalone.podDisruptionBudget | object | `{}` | Pod disruption budget for standalone pods |
| standalone.priorityClassName | string | `""` | Priority class name for standalone pods |
| standalone.readinessProbe.initialDelaySeconds | int | `20` | Initial delay before starting readiness probes |
| standalone.readinessProbe.periodSeconds | int | `10` | Period between readiness probes |
| standalone.readinessProbe.timeoutSeconds | int | `5` | Timeout for readiness probes |
| standalone.readinessProbe.successThreshold | int | `1` | Success threshold for readiness probes |
| standalone.readinessProbe.failureThreshold | int | `5` | Failure threshold for readiness probes |
| standalone.resources.limits | list | `[]` | Resource limits for standalone pods |
| standalone.resources.requests | list | `[]` | Resource requests for standalone pods |
| standalone.securityContext | object | `{}` | Security context for standalone pods |
| standalone.sidecar | list | `[]` | Sidecar containers for standalone pods |
| standalone.tls.grpcSecretName | string | `""` | Secret name for gRPC TLS in standalone mode |
| standalone.tls.httpSecretName | string | `""` | Secret name for HTTP TLS in standalone mode |
| standalone.tolerations | list | `[]` | Tolerations for standalone pods |
| storage.enabled | bool | `false` | Enable or disable storage |
| storage.persistentVolumeClaims[0].accessModes[0] | string | `"ReadWriteOnce"` | Access modes for the first PVC |
| storage.persistentVolumeClaims[0].claimName | string | `"data"` | Claim name for the first PVC |
| storage.persistentVolumeClaims[0].existingClaimName | string | `nil` | Existing claim name for the first PVC |
| storage.persistentVolumeClaims[0].mountTargets[0] | string | `"measure"` | First mount target for the first PVC |
| storage.persistentVolumeClaims[0].mountTargets[1] | string | `"stream"` | Second mount target for the first PVC |
| storage.persistentVolumeClaims[0].size | string | `"50Gi"` | Size of the first PVC |
| storage.persistentVolumeClaims[0].storageClass | string | `nil` | Storage class for the first PVC |
| storage.persistentVolumeClaims[0].volumeMode | string | `"Filesystem"` | Volume mode for the first PVC |
| storage.persistentVolumeClaims[1].accessModes[0] | string | `"ReadWriteOnce"` | Access modes for the second PVC |
| storage.persistentVolumeClaims[1].claimName | string | `"meta"` | Claim name for the second PVC |
| storage.persistentVolumeClaims[1].existingClaimName | string | `nil` | Existing claim name for the second PVC |
| storage.persistentVolumeClaims[1].mountTargets[0] | string | `"metadata"` | Mount target for the second PVC |
| storage.persistentVolumeClaims[1].size | string | `"5Gi"` | Size of the second PVC |
| storage.persistentVolumeClaims[1].storageClass | string | `nil` | Storage class for the second PVC |
| storage.persistentVolumeClaims[1].volumeMode | string | `"Filesystem"` | Volume mode for the second PVC |

Specify each parameter using the `--set key=value[,key=value]` argument to `helm install`. For example,

**Note** You could refer to the [helm install](https://helm.sh/docs/helm/helm_install/) for more command information.

```console
$ helm install myrelease banyandb --set fullnameOverride=newBanyanDB
```

Alternatively, a YAML file that specifies the values for the above parameters can be provided while installing the chart. For example,

```console
$ helm install my-release banyandb -f values.yaml
```

> **Tip**: You can use the default [values.yaml](chart/values.yaml)

## Use external certificate authorities for TLS
If you'd like to use external certificate authorities, such as Vault, corresponding annotations can be injected into [banyandb](./chart/templates/statefulset.yaml).

## Setup certificate for etcd TLS
To establish secure communication for etcd, you can leverage cert-manager to generate the necessary TLS certificates. This tool simplifies the process of creating and managing certificates. You can install cert-manager with the following command.
```console
kubectl apply -f https://github.com/cert-manager/cert-manager/releases/download/v1.14.4/cert-manager.yaml
```

A Certificate can be created with the following configurations. In this setup, each dnsName includes a wildcard that enables resolution of all etcd pods' DNS names within the specified namespace, along with the service name of etcd and its corresponding namespace. Here, 'svc' represents a service, while 'cluster.local' serves as the domain suffix for the Kubernetes cluster.
```yaml
apiVersion: cert-manager.io/v1
kind: Certificate
metadata:
  name: etcd-client
  namespace: banyandb
spec:
  secretName: etcd-client-tls
  duration: 17520h
  renewBefore: 4320h
  issuerRef:
    name: banyandb-issuer
    kind: Issuer
  usages:
    - server auth
    - client auth
  dnsNames:
    - "*.banyandb-etcd.banyandb.svc.cluster.local"
    - "*.banyandb-etcd-headless.banyandb.svc.cluster.local"
```

# Install the development version of BanyanDB using the master branch
This is needed **only** when you want to install [BanyanDB](https://github.com/apache/skywalking-banyandb/tree/main) from the master branch. 

You can install BanyanDB with the default configuration as follows.

```shell script
export REPO=chart
git clone https://github.com/apache/skywalking-banyandb-helm
cd skywalking-banyandb-helm
helm dependency build ${REPO}
helm install banyandb ${REPO}
```

# Contact Us
* Submit an [issue](https://github.com/apache/skywalking/issues)
* Mail list: **dev@skywalking.apache.org**. Mail to `dev-subscribe@skywalking.apache.org`, follow the reply to subscribe the mail list.
* Send `Request to join SkyWalking slack` mail to the mail list(`dev@skywalking.apache.org`), we will invite you in.
* For Chinese speaker, send `[CN] Request to join SkyWalking slack` mail to the mail list(`dev@skywalking.apache.org`), we will invite you in.
* Twitter, [ASFSkyWalking](https://twitter.com/AsfSkyWalking)
* [bilibili B站 视频](https://space.bilibili.com/390683219)

# LICENSE
Apache 2.0
