Apache SkyWalking BanyanDB Helm Chart
==========


![](https://github.com/apache/skywalking-banyandb-helm/workflows/Build/badge.svg?branch=master)

BanyanDB, as an observability database, aims to ingest, analyze and store Metrics, Tracing, and Logging data.
It's designed to handle observability data generated by observability platforms and APM systems, like [Apache SkyWalking](https://github.com/apache/skywalking) etc.

BanyanDB Helm Chart repository provides ways to install and configure SkyWalking in a BanyanDB cluster. The scripts are written in Helm 3.

# Chart Detailed Configuration

BanyanDB chart detailed configuration can be found at [BanyanDB Chart Readme](./chart/README.md).

## Use external certificate authorities for TLS
If you'd like to use external certificate authorities, such as Vault, corresponding annotations can be injected into [banyandb](./chart/templates/statefulset.yaml).

# Install development version of BanyanDB using main branch
This is needed **only** when you want to install [BanyanDB](https://github.com/apache/skywalking-banyandb/tree/main) from main branch. 

You can install BanyanDB with the default configuration as follows.

```shell script
export REPO=chart
git clone https://github.com/apache/skywalking-banyandb-helm
cd skywalking-banyandb-helm
helm install banyandb ${REPO}
```

# Contact Us
* Submit an [issue](https://github.com/apache/skywalking/issues)
* Mail list: **dev@skywalking.apache.org**. Mail to `dev-subscribe@skywalking.apache.org`, follow the reply to subscribe the mail list.
* Send `Request to join SkyWalking slack` mail to the mail list(`dev@skywalking.apache.org`), we will invite you in.
* For Chinese speaker, send `[CN] Request to join SkyWalking slack` mail to the mail list(`dev@skywalking.apache.org`), we will invite you in.
* Twitter, [ASFSkyWalking](https://twitter.com/AsfSkyWalking)
* [bilibili B站 视频](https://space.bilibili.com/390683219)

# LICENSE
Apache 2.0
