# INI Settings

This is the configuration list supported in `php.ini`.

| Configuration Item                               | Description                                                                                                                                                                                                                                       | Default Value             |
| ------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------- |
| skywalking_agent.enable                          | Enable skywalking_agent extension or not.                                                                                                                                                                                                         | Off                       |
| skywalking_agent.log_file                        | Log file path.                                                                                                                                                                                                                                    | /tmp/skywalking-agent.log |
| skywalking_agent.log_level                       | Log level: one of `OFF`, `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`.                                                                                                                                                                               | INFO                      |
| skywalking_agent.runtime_dir                     | Skywalking agent runtime directory.                                                                                                                                                                                                               | /tmp/skywalking-agent     |
| skywalking_agent.server_addr                     | Address of skywalking oap server. Only available when `reporter_type` is `grpc`.                                                                                                                                                                  | 127.0.0.1:11800           |
| skywalking_agent.service_name                    | Application service name.                                                                                                                                                                                                                         | hello-skywalking          |
| skywalking_agent.skywalking_version              | Skywalking version, 8 or 9.                                                                                                                                                                                                                       | 8                         |
| skywalking_agent.authentication                  | Skywalking authentication token, let it empty if the backend isn't enabled. Only available when `reporter_type` is `grpc`.                                                                                                                        |                           |
| skywalking_agent.worker_threads                  | Skywalking worker threads, 0 will auto set as the cpu core size.                                                                                                                                                                                  | 0                         |
| skywalking_agent.enable_tls                      | Wether to enable tls for gPRC, default is false. Only available when `reporter_type` is `grpc`.                                                                                                                                                   | Off                       |
| skywalking_agent.ssl_trusted_ca_path             | The gRPC SSL trusted ca file. Only available when `reporter_type` is `grpc`.                                                                                                                                                                      |                           |
| skywalking_agent.ssl_key_path                    | The private key file. Enable mTLS when `ssl_key_path` and `ssl_cert_chain_path` exist. Only available when `reporter_type` is `grpc`.                                                                                                             |                           |
| skywalking_agent.ssl_cert_chain_path             | The certificate file. Enable mTLS when `ssl_key_path` and `ssl_cert_chain_path` exist. Only available when `reporter_type` is `grpc`.                                                                                                             |                           |
| skywalking_agent.heartbeat_period                | Agent heartbeat report period. Unit, second.                                                                                                                                                                                                      | 30                        |
| skywalking_agent.properties_report_period_factor | The agent sends the instance properties to the backend every heartbeat_period * properties_report_period_factor seconds.                                                                                                                          | 10                        |
| skywalking_agent.enable_zend_observer            | Whether to use `zend observer` instead of `zend_execute_ex` to hook the functions, this feature is only available for PHP8+.                                                                                                                      | Off                       |
| skywalking_agent.reporter_type                   | Reporter type, optional values are `grpc`, `kafka` and `standalone`.                                                                                                                                                                                            | grpc                      |
| skywalking_agent.kafka_bootstrap_servers         | A list of host/port pairs to use for connect to the Kafka cluster. Only available when `reporter_type` is `kafka`.                                                                                                                                |                           |
| skywalking_agent.kafka_producer_config           | Configure Kafka Producer configuration in JSON format `{"key": "value}`. Only available when `reporter_type` is `kafka`.                                                                                                                          | {}                        |
| skywalking_agent.inject_context                  | Whether to enable automatic injection of skywalking context variables (such as `SW_TRACE_ID`). For `php-fpm` mode, it will be injected into the `$_SERVER` variable. For `swoole` mode, it will be injected into the `$request->server` variable. | Off                       |
| skywalking_agent.instance_name                   | Instance name. You can set `${HOSTNAME}`, refer to [Example #1](https://www.php.net/manual/en/install.fpm.configuration.php)                                                                                                                       |                           |
| skywalking_agent.standalone_socket_path          | Unix domain socket file path of standalone skywalking php worker. Only available when `reporter_type` is `standalone`.                                                                                                                            |                           |
