/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.xslt.AbstractAdapterElement;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanAdapter
extends AbstractAdapterElement {
    private static final Object[] NULLPARAMS = new Object[0];
    private static Map<Class, PropertyDescriptor[]> propertyDescriptorCache;
    private Logger log = LogManager.getLogger(this.getClass());

    public BeanAdapter() {
    }

    public BeanAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, Object value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    @Override
    public String getTagName() {
        return this.getPropertyName();
    }

    @Override
    public NodeList getChildNodes() {
        NodeList nl = super.getChildNodes();
        if (this.log.isDebugEnabled() && nl != null) {
            this.log.debug("BeanAdapter getChildNodes for: {}", (Object)this.getTagName());
            this.log.debug(nl.toString());
        }
        return nl;
    }

    @Override
    protected List<Node> buildChildAdapters() {
        this.log.debug("BeanAdapter building children. Property name: {}", (Object)this.getPropertyName());
        ArrayList<Node> newAdapters = new ArrayList<Node>();
        Class<?> type = this.getPropertyValue().getClass();
        PropertyDescriptor[] props = this.getPropertyDescriptors(this.getPropertyValue());
        if (props.length > 0) {
            for (PropertyDescriptor prop : props) {
                Object propertyValue;
                Method m = prop.getReadMethod();
                if (m == null) continue;
                this.log.debug("Bean reading property method: {}", (Object)m.getName());
                String propertyName = prop.getName();
                try {
                    propertyValue = m.invoke(this.getPropertyValue(), NULLPARAMS);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        e = (Exception)((InvocationTargetException)e).getTargetException();
                    }
                    this.log.error("Cannot access bean property: {}", (Object)propertyName, (Object)e);
                    continue;
                }
                Node childAdapter = propertyValue == null ? this.getAdapterFactory().adaptNullValue(this, propertyName) : this.getAdapterFactory().adaptNode(this, propertyName, propertyValue);
                if (childAdapter != null) {
                    newAdapters.add(childAdapter);
                }
                this.log.debug("{} adding adapter: {}", (Object)this, (Object)childAdapter);
            }
        } else {
            this.log.info("Class {} has no readable properties, trying to adapt {} with StringAdapter...", (Object)type.getName(), (Object)this.getPropertyName());
        }
        return newAdapters;
    }

    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        try {
            PropertyDescriptor[] props;
            if (propertyDescriptorCache == null) {
                propertyDescriptorCache = new HashMap<Class, PropertyDescriptor[]>();
            }
            if ((props = propertyDescriptorCache.get(bean.getClass())) == null) {
                this.log.debug("Caching property descriptor for {}", (Object)bean.getClass().getName());
                props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
                propertyDescriptorCache.put(bean.getClass(), props);
            }
            return props;
        }
        catch (IntrospectionException e) {
            throw new StrutsException("Error getting property descriptors for " + bean + " : " + e.getMessage());
        }
    }
}

