/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.crypto.CryptoAlgorithm;
import org.apache.fulcrum.crypto.CryptoService;

public class DefaultCryptoService
extends AbstractLogEnabled
implements CryptoService,
Configurable,
Initializable,
ThreadSafe {
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_KEY = "default";
    private static final String DEFAULT_CLASS = "org.apache.fulcrum.crypto.provider.JavaCrypt";
    private HashMap<String, String> algos = new HashMap();

    @Override
    public CryptoAlgorithm getCryptoAlgorithm(String algo) throws NoSuchAlgorithmException {
        String cryptoClass = this.algos.get(algo);
        CryptoAlgorithm ca = null;
        if (cryptoClass == null) {
            cryptoClass = this.algos.get(DEFAULT_KEY);
        }
        if (cryptoClass == null || cryptoClass.equalsIgnoreCase("none")) {
            throw new NoSuchAlgorithmException("TurbineCryptoService: No Algorithm for " + algo + " found");
        }
        try {
            ca = (CryptoAlgorithm)Class.forName(cryptoClass).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("TurbineCryptoService: Error instantiating " + cryptoClass + " for " + algo);
        }
        ca.setCipher(algo);
        return ca;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.algos = new HashMap();
        this.algos.put(DEFAULT_KEY, DEFAULT_CLASS);
        Configuration algorithms = conf.getChild(ALGORITHM, false);
        if (algorithms != null) {
            Configuration[] nameVal;
            for (Configuration entry : nameVal = algorithms.getChildren()) {
                this.algos.put(entry.getName(), entry.getValue());
            }
        }
    }

    public void initialize() throws Exception {
        this.getLogger().debug("initialize()");
    }

    public void dispose() {
        this.algos = null;
    }
}

