/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.fulcrum.json.JsonService;
import org.apache.fulcrum.json.jackson.CacheService;
import org.apache.fulcrum.json.jackson.CustomModule;
import org.apache.fulcrum.json.jackson.MixinModule;
import org.apache.fulcrum.json.jackson.SimpleNameIntrospector;
import org.apache.fulcrum.json.jackson.filters.CustomModuleWrapper;
import org.apache.fulcrum.json.jackson.jsonpath.DefaultJsonPathWrapper;

public class Jackson2MapperService
extends AbstractLogEnabled
implements JsonService,
Initializable,
Configurable {
    private static final String DEFAULT_TYPING = "defaultTyping";
    private static final String CACHE_FILTERS = "cacheFilters";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String ESCAPE_CHARS = "escapeCharsGlobal";
    private static final String ESCAPE_CHAR_CLASS = "escapeCharsClass";
    private static final String USEJSONPATH = "useJsonPath";
    ObjectMapper mapper;
    AnnotationIntrospector primary;
    AnnotationIntrospector secondary;
    public String ANNOTATIONINSPECTOR = "annotationInspectors";
    private Hashtable<String, String> annotationInspectors = null;
    private Hashtable<String, Boolean> features = null;
    private Hashtable<String, String> featureTypes = null;
    private String dateFormat;
    public final String DEFAULTDATEFORMAT = "MM/dd/yyyy";
    final boolean defaultType = false;
    public boolean cacheFilters = true;
    String[] defaultTypeDefs = null;
    private CacheService cacheService;
    private boolean escapeCharsGlobal = false;
    private boolean useJsonPath = false;
    private String escapeCharsClass = null;
    static CharacterEscapes characterEscapes = new CharacterEscapes(){
        private static final long serialVersionUID = 1L;
        private final int[] asciiEscapes;
        {
            int[] esc = 2.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    };

    public String ser(Object src) throws Exception {
        return this.ser(src, false);
    }

    public <T> String ser(Object src, Class<T> type) throws Exception {
        return this.ser(src, type, (Boolean)false);
    }

    public <T> String ser(Object src, FilterProvider filter) throws Exception {
        return this.ser(src, filter, (Boolean)false);
    }

    public <T> String ser(Object src, FilterProvider filter, Boolean cleanCache) throws Exception {
        String serResult = null;
        if (src == null) {
            this.getLogger().info("no serializable object.");
            return serResult;
        }
        if (filter == null) {
            this.getLogger().debug("ser class::" + src.getClass() + " without filter.");
            return this.ser(src);
        }
        this.getLogger().debug("add filter for cache filter Class " + src.getClass().getName());
        this.setCustomIntrospectorWithExternalFilterId(src.getClass(), null);
        if (filter != null) {
            this.cacheService.getFilters().put(src.getClass().getName(), filter);
        }
        this.getLogger().debug("ser class::" + src.getClass() + " with filter " + filter);
        this.mapper.setFilterProvider(filter);
        String res = this.mapper.writer(filter).writeValueAsString(src);
        if (cleanCache.booleanValue()) {
            this.cacheService.cleanSerializerCache(this.mapper);
        }
        return res;
    }

    public <T> T deSer(String json, Class<T> type) throws Exception {
        ObjectReader reader = null;
        reader = type != null ? this.mapper.readerFor(type) : this.mapper.reader();
        return (T)reader.readValue(json);
    }

    public <T> Collection<T> deSerCollectionWithType(String json, Class<? extends Collection> collectionClass, Class<T> type) throws Exception {
        return (Collection)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(collectionClass, type));
    }

    public <T> String serCollectionWithTypeReference(Collection<T> src, TypeReference collectionType, Boolean cleanCache) throws Exception {
        String res = this.mapper.writerFor(collectionType).writeValueAsString(src);
        if (cleanCache.booleanValue()) {
            this.cacheService.cleanSerializerCache(this.mapper);
        }
        return res;
    }

    public <T> Collection<T> deSerCollection(String json, Object collectionType, Class<T> elementType) throws Exception {
        if (collectionType instanceof TypeReference) {
            return (Collection)this.mapper.readValue(json, (TypeReference)collectionType);
        }
        return (Collection)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(((Collection)collectionType).getClass(), elementType));
    }

    public <T> List<T> deSerList(String json, Class<? extends List> targetList, Object listType, Class<T> elementType) throws Exception {
        return (List)this.mapper.readValue(json, this.mapper.getTypeFactory().constructParametrizedType(targetList, listType.getClass(), new Class[]{elementType}));
    }

    public <T, U> Map<T, U> deSerMap(String json, Class<? extends Map> mapClass, Class<T> keyClass, Class<U> valueClass) throws Exception {
        return (Map)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructMapType(mapClass, keyClass, valueClass));
    }

    public <T> Collection<T> deSerCollectionWithTypeReference(String json, TypeReference<T> collectionType) throws Exception {
        return (Collection)this.mapper.readValue(json, collectionType);
    }

    public void getJsonService() throws InstantiationException {
    }

    public JsonService addAdapter(String name, Class target, Class mixin) throws Exception {
        this.getLogger().debug("registering unversioned simple mixin module named " + name + " of type " + mixin + "  for: " + target);
        this.mapper.addMixIn(target, mixin);
        return this;
    }

    public JsonService addAdapter(String name, Class target, Object module) throws Exception {
        if (module instanceof CustomModuleWrapper) {
            CustomModuleWrapper cmw = (CustomModuleWrapper)module;
            CustomModule cm = new CustomModule(name, target, cmw.getSer(), cmw.getDeSer());
            this.getLogger().debug("registering custom module " + cm + "  for: " + target);
            this.mapper.registerModule(cm);
        } else if (module instanceof Module) {
            this.getLogger().debug("registering module " + module);
            this.mapper.registerModule((Module)module);
        } else {
            throw new Exception("expecting module type" + Module.class);
        }
        return this;
    }

    public String withMixinModule(Object src, String name, Class target, Class mixin) throws JsonProcessingException {
        MixinModule mx = new MixinModule(name, target, mixin);
        this.getLogger().debug("registering module " + (Object)((Object)mx) + "  for: " + mixin);
        return this.mapper.registerModule((Module)mx).writer().writeValueAsString(src);
    }

    public <T> String serializeAllExceptFilter(Object src, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, src.getClass(), (Boolean)true, filterAttr);
    }

    public synchronized <T> String serializeAllExceptFilter(Object src, Boolean cache, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, src.getClass(), cache, filterAttr);
    }

    public synchronized <T> String serializeAllExceptFilter(Object src, Class<T>[] filterClasses, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, filterClasses, (Boolean)true, filterAttr);
    }

    public synchronized <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, filterClass, (Boolean)true, filterAttr);
    }

    public <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, Boolean cleanFilter, String ... filterAttr) throws Exception {
        return this.serializeAllExceptFilter(src, new Class[]{filterClass}, cleanFilter, filterAttr);
    }

    public synchronized <T> String serializeAllExceptFilter(Object src, Class<T>[] filterClasses, Boolean clean, String ... filterAttr) throws Exception {
        SimpleBeanPropertyFilter pf = null;
        if (filterAttr != null) {
            pf = SimpleBeanPropertyFilter.serializeAllExcept((String[])filterAttr);
        } else if (filterClasses == null) {
            return this.ser(src, clean);
        }
        return this.filter(src, new Class[]{filterClasses[0]}, filterClasses, (PropertyFilter)pf, clean);
    }

    public <T> String serializeOnlyFilter(Object src, String ... filterAttrs) throws Exception {
        return this.serializeOnlyFilter(src, src.getClass(), (Boolean)true, filterAttrs);
    }

    public synchronized <T> String serializeOnlyFilter(Object src, Boolean cache, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, src.getClass(), cache, filterAttr);
    }

    public synchronized <T> String serializeOnlyFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, filterClass, (Boolean)true, filterAttr);
    }

    public synchronized <T> String serializeOnlyFilter(Object src, Class<T> filterClass, Boolean refresh, String ... filterAttr) throws Exception {
        return this.serializeOnlyFilter(src, new Class[]{filterClass}, refresh, filterAttr);
    }

    public synchronized <T> String serializeOnlyFilter(Object src, Class<T>[] filterClasses, Boolean refresh, String ... filterAttr) throws Exception {
        SimpleBeanPropertyFilter pf = null;
        if (filterAttr != null && filterAttr.length > 0 && !"".equals(filterAttr[0])) {
            pf = SimpleBeanPropertyFilter.filterOutAllExcept((String[])filterAttr);
            this.getLogger().debug("setting filteroutAllexcept filter for size of filterAttr: " + filterAttr.length);
        } else {
            this.getLogger().warn("no filter attributes set!");
            pf = SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"dummy"});
        }
        if (filterClasses == null) {
            throw new Exception("You have to provide some class to apply the filtering!");
        }
        return this.filter(src, filterClasses, null, (PropertyFilter)pf, refresh);
    }

    public String ser(Object src, Boolean cleanCache) throws Exception {
        if (this.cacheService.getFilters().containsKey(src.getClass().getName())) {
            this.getLogger().warn("Found registered filter - using instead of default view filter for class:" + src.getClass().getName());
            SimpleFilterProvider filter = (SimpleFilterProvider)this.cacheService.getFilters().get(src.getClass().getName());
            return this.ser(src, (FilterProvider)filter, cleanCache);
        }
        String res = this.mapper.writerWithView(Object.class).writeValueAsString(src);
        if (cleanCache != null && cleanCache.booleanValue()) {
            this.cacheService.cleanSerializerCache(this.mapper);
        }
        return res;
    }

    public <T> String ser(Object src, Class<T> type, Boolean cleanCache) throws Exception {
        String res;
        this.getLogger().info("serializing object:" + src + " for type " + type);
        if (src != null && this.cacheService.getFilters().containsKey(src.getClass().getName())) {
            this.getLogger().warn("Found registered filter - could not use custom view and custom filter for class:" + src.getClass().getName());
            SimpleFilterProvider filter = (SimpleFilterProvider)this.cacheService.getFilters().get(src.getClass().getName());
            return this.ser(src, (FilterProvider)filter);
        }
        String string = res = type != null ? this.mapper.writerWithView(type).writeValueAsString(src) : this.mapper.writeValueAsString(src);
        if (cleanCache.booleanValue()) {
            this.cacheService.cleanSerializerCache(this.mapper);
        }
        return res;
    }

    private <T> String filter(Object src, Class<?>[] filterClasses, Class<T>[] excludeClasses, PropertyFilter pf, Boolean clean) throws Exception {
        SimpleFilterProvider filter = null;
        if (filterClasses.length > 0) {
            filter = this.retrieveFilter(pf, filterClasses[0], excludeClasses);
        }
        this.getLogger().info("filtering with filter " + filter);
        String serialized = this.ser(src, (FilterProvider)filter, clean);
        if ((!this.cacheFilters || clean.booleanValue()) && filterClasses.length > 0) {
            boolean exclude = excludeClasses != null;
            this.cacheService.removeFilter(filterClasses[0], exclude);
        }
        return serialized;
    }

    private <T> SimpleFilterProvider retrieveFilter(PropertyFilter pf, Class<?> filterClass, Class<T>[] excludeClasses) {
        SimpleFilterProvider filter = null;
        if (pf != null) {
            filter = new SimpleFilterProvider();
            filter.setDefaultFilter(pf);
        }
        if (!this.cacheService.getFilters().containsKey(filterClass.getName())) {
            this.getLogger().debug("add filter for cache filter Class " + filterClass.getName());
            this.setCustomIntrospectorWithExternalFilterId(filterClass, excludeClasses);
            if (pf != null) {
                this.cacheService.getFilters().put(filterClass.getName(), (FilterProvider)filter);
            }
        } else {
            filter = (SimpleFilterProvider)this.cacheService.getFilters().get(filterClass.getName());
        }
        this.getLogger().debug("set filter:" + filter);
        return filter;
    }

    private <T> void setCustomIntrospectorWithExternalFilterId(Class<?> filterClass, Class<T>[] externalFilterClassIds) {
        if (this.primary instanceof SimpleNameIntrospector) {
            ((SimpleNameIntrospector)this.primary).setFilteredClasses(filterClass);
            if (externalFilterClassIds != null) {
                ((SimpleNameIntrospector)this.primary).setIsExludeType(true);
                for (Class<T> filterClazz : externalFilterClassIds) {
                    this.getLogger().debug("added class for filters " + filterClazz);
                }
                ((SimpleNameIntrospector)this.primary).setExternalFilterExcludeClasses(externalFilterClassIds);
            }
        }
    }

    public Jackson2MapperService registerModule(Module module) {
        this.mapper.registerModule(module);
        return this;
    }

    public <T> void addSimpleModule(SimpleModule module, Class<T> type, JsonSerializer<T> ser) {
        module.addSerializer(type, ser);
    }

    public <T> void addSimpleModule(SimpleModule module, Class<T> type, JsonDeserializer<T> deSer) {
        module.addDeserializer(type, deSer);
    }

    public void setDateFormat(DateFormat df) {
        this.mapper.setDateFormat(df);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration configuredjsonPath;
        Configuration configuredDefaultType;
        Configuration configuredEscapeCharClass;
        Configuration configuredEscapeChars;
        this.getLogger().debug("conf.getName()" + conf.getName());
        this.annotationInspectors = new Hashtable();
        Configuration configuredAnnotationInspectors = conf.getChild(this.ANNOTATIONINSPECTOR, false);
        if (configuredAnnotationInspectors != null) {
            Configuration[] nameVal = configuredAnnotationInspectors.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                this.getLogger().debug("configured key: " + key);
                if (key.equals("features")) {
                    this.features = new Hashtable();
                    this.featureTypes = new Hashtable();
                    Configuration[] features = nameVal[i].getChildren();
                    for (int j = 0; j < features.length; ++j) {
                        boolean featureValue = features[j].getAttributeAsBoolean("value", false);
                        String featureType = features[j].getAttribute("type");
                        String feature = features[j].getValue();
                        this.getLogger().debug("configuredAnnotationInspectors " + feature + ":" + featureValue);
                        this.features.put(feature, featureValue);
                        this.featureTypes.put(feature, featureType);
                    }
                    continue;
                }
                String val = nameVal[i].getValue();
                this.getLogger().debug("configuredAnnotationInspectors " + key + ":" + val);
                this.annotationInspectors.put(key, val);
            }
        }
        Configuration configuredDateFormat = conf.getChild(DATE_FORMAT, true);
        this.dateFormat = configuredDateFormat.getValue("MM/dd/yyyy");
        Configuration configuredKeepFilter = conf.getChild(CACHE_FILTERS, false);
        if (configuredKeepFilter != null) {
            this.cacheFilters = configuredKeepFilter.getValueAsBoolean();
        }
        if ((configuredEscapeChars = conf.getChild(ESCAPE_CHARS, false)) != null) {
            this.escapeCharsGlobal = configuredEscapeChars.getValueAsBoolean();
        }
        if ((configuredEscapeCharClass = conf.getChild(ESCAPE_CHAR_CLASS, false)) != null) {
            this.escapeCharsClass = configuredEscapeCharClass.getValue();
        }
        if ((configuredDefaultType = conf.getChild(DEFAULT_TYPING, false)) != null) {
            this.defaultTypeDefs = new String[]{configuredDefaultType.getAttribute("type"), configuredDefaultType.getAttribute("key")};
        }
        if ((configuredjsonPath = conf.getChild(USEJSONPATH, false)) != null) {
            this.useJsonPath = configuredjsonPath.getValueAsBoolean();
        }
    }

    public void initialize() throws Exception {
        this.mapper = new ObjectMapper(null, null, null);
        Enumeration<String> enumKey = this.annotationInspectors.keys();
        while (enumKey.hasMoreElements()) {
            String key = enumKey.nextElement();
            String avClass = this.annotationInspectors.get(key);
            if (key.equals("primary") && avClass != null) {
                try {
                    this.primary = (AnnotationIntrospector)Class.forName(avClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("JsonMapperService: Error instantiating " + avClass + " for " + key);
                }
            }
            if (!key.equals("secondary") || avClass == null) continue;
            try {
                this.secondary = (AnnotationIntrospector)Class.forName(avClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new Exception("JsonMapperService: Error instantiating " + avClass + " for " + key);
            }
        }
        if (this.primary == null) {
            this.primary = new JacksonAnnotationIntrospector();
            this.getLogger().info("using default introspector:" + this.primary.getClass().getName());
            this.mapper.setAnnotationIntrospector(this.primary);
        } else if (this.primary != null && this.secondary != null) {
            AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(this.primary, this.secondary);
            this.mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        } else {
            this.mapper.setAnnotationIntrospector(this.primary);
        }
        if (this.primary instanceof LogEnabled) {
            ((LogEnabled)this.primary).enableLogging(this.getLogger().getChildLogger(this.primary.getClass().getSimpleName()));
            this.getLogger().info("setting primary introspector logger: " + this.primary.getClass().getSimpleName());
        }
        if (this.secondary instanceof LogEnabled) {
            ((LogEnabled)this.secondary).enableLogging(this.getLogger().getChildLogger(this.secondary.getClass().getSimpleName()));
            this.getLogger().info("setting secondary introspector logger: " + this.secondary.getClass().getSimpleName());
        }
        if (this.features != null && !this.features.isEmpty()) {
            Enumeration<String> enumFeatureKey = this.features.keys();
            while (enumFeatureKey.hasMoreElements()) {
                String featureKey = enumFeatureKey.nextElement();
                Boolean featureValue = this.features.get(featureKey);
                String featureType = this.featureTypes.get(featureKey);
                Class<?> configFeature = null;
                try {
                    this.getLogger().debug("initializing featureType:  " + featureType);
                    configFeature = Class.forName(featureType);
                }
                catch (Exception e) {
                    throw new Exception("JsonMapperService: Error instantiating " + featureType + " for " + featureKey, e);
                }
                SerializationFeature feature = null;
                if (featureKey == null || featureValue == null) continue;
                try {
                    if (configFeature.equals(SerializationFeature.class)) {
                        feature = SerializationFeature.valueOf((String)featureKey);
                        this.mapper.configure(feature, featureValue.booleanValue());
                        assert (this.mapper.getSerializationConfig().isEnabled(feature) == featureValue.booleanValue());
                        this.getLogger().info("initialized serconfig mapper feature: " + feature + " with " + this.mapper.getSerializationConfig().isEnabled(feature));
                        continue;
                    }
                    if (configFeature.equals(DeserializationFeature.class)) {
                        feature = DeserializationFeature.valueOf((String)featureKey);
                        this.mapper.configure((DeserializationFeature)feature, featureValue.booleanValue());
                        assert (this.mapper.getDeserializationConfig().isEnabled((DeserializationFeature)feature) == featureValue.booleanValue());
                        this.getLogger().info("initialized deserconfig mapper feature: " + feature + " with " + this.mapper.getDeserializationConfig().isEnabled((DeserializationFeature)feature));
                        continue;
                    }
                    if (configFeature.equals(MapperFeature.class)) {
                        feature = MapperFeature.valueOf((String)featureKey);
                        this.mapper.configure((MapperFeature)feature, featureValue.booleanValue());
                        assert (this.mapper.getDeserializationConfig().isEnabled((MapperFeature)feature) == featureValue.booleanValue());
                        assert (this.mapper.getSerializationConfig().isEnabled((MapperFeature)feature) == featureValue.booleanValue());
                        this.getLogger().info("initialized serconfig mapper feature: " + feature + " with " + this.mapper.getDeserializationConfig().isEnabled((MapperFeature)feature));
                        this.getLogger().info("initialized deserconfig mapper feature: " + feature + " with " + this.mapper.getSerializationConfig().isEnabled((MapperFeature)feature));
                        continue;
                    }
                    if (configFeature.equals(JsonParser.class)) {
                        JsonParser.Feature parserFeature = JsonParser.Feature.valueOf((String)featureKey);
                        this.getLogger().info("initializing parser feature: " + parserFeature + " with " + featureValue);
                        this.mapper.configure(parserFeature, featureValue.booleanValue());
                        continue;
                    }
                    if (!configFeature.equals(JsonGenerator.class)) continue;
                    JsonGenerator.Feature genFeature = JsonGenerator.Feature.valueOf((String)featureKey);
                    this.getLogger().info("initializing parser feature: " + genFeature + " with " + featureValue);
                    this.mapper.configure(genFeature, featureValue.booleanValue());
                }
                catch (Exception e) {
                    throw new Exception("JsonMapperService: Error instantiating feature " + featureKey + " with  " + featureValue, e);
                }
            }
        }
        if (this.defaultTypeDefs != null && this.defaultTypeDefs.length == 2) {
            ObjectMapper.DefaultTyping defaultTyping = ObjectMapper.DefaultTyping.valueOf((String)this.defaultTypeDefs[0]);
            this.mapper.enableDefaultTypingAsProperty(defaultTyping, this.defaultTypeDefs[1]);
            this.getLogger().info("default typing is " + this.defaultTypeDefs[0] + " with key:" + this.defaultTypeDefs[1]);
        }
        this.getLogger().info("setting date format to:" + this.dateFormat);
        this.getLogger().info("cacheFilters is:" + this.cacheFilters);
        if (!this.cacheFilters) {
            this.mapper.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, true);
        }
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormat));
        if (this.escapeCharsGlobal) {
            this.mapper.getFactory().setCharacterEscapes(characterEscapes);
        }
        if (this.escapeCharsClass != null) {
            try {
                characterEscapes = (CharacterEscapes)Class.forName(this.escapeCharsClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new Exception("JsonMapperService: Error instantiating " + this.escapeCharsClass + " for " + ESCAPE_CHAR_CLASS);
            }
        }
        this.getLogger().debug("initialized mapper:" + this.mapper);
        this.mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString("");
            }
        });
        this.cacheService = new CacheService(this.primary);
        if (this.cacheService instanceof LogEnabled) {
            this.cacheService.enableLogging(this.getLogger().getChildLogger(this.cacheService.getClass().getSimpleName()));
            this.getLogger().info("setting cacheService logger: " + this.cacheService.getClass().getSimpleName());
        }
        if (this.useJsonPath) {
            DefaultJsonPathWrapper djpw = null;
            try {
                djpw = new DefaultJsonPathWrapper(this.mapper);
                this.getLogger().debug("******** initialized new jsonPath defaults: " + djpw.getJsonPathDefault());
            }
            catch (Exception e) {
                throw new Exception("JsonMapperService: Error instantiating " + djpw + " using useJsonPath=" + this.useJsonPath);
            }
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public boolean isCacheFilters() {
        return this.cacheFilters;
    }

    public void setCacheFilters(boolean cacheFilters) {
        this.cacheFilters = cacheFilters;
        if (!cacheFilters) {
            this.mapper.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, true);
        }
    }
}

