/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.jackson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;

public class CustomIntrospector
extends JacksonAnnotationIntrospector {
    public List<String> externalFilterClasses = Collections.synchronizedList(new ArrayList());

    public Object findFilterId(AnnotatedClass ac) {
        Object id = super.findFilterId(ac);
        if (id == null) {
            String name = ac.getName();
            if (!this.externalFilterClasses.isEmpty() && this.externalFilterClasses.contains(name)) {
                id = name;
            }
        }
        return id;
    }

    public List<String> getExternalFilterClasses() {
        return this.externalFilterClasses;
    }

    public void setExternalFilterClass(Class externalFilterClass) {
        if (!this.externalFilterClasses.contains(externalFilterClass.getName())) {
            this.externalFilterClasses.add(externalFilterClass.getName());
        }
    }

    public void setExternalFilterClasses(Class ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (this.externalFilterClasses.contains(classes[i].getName())) continue;
            this.externalFilterClasses.add(classes[i].getName());
        }
    }

    public void removeExternalFilterClass(Class externalFilterClass) {
        if (this.externalFilterClasses.contains(externalFilterClass.getName())) {
            this.externalFilterClasses.remove(externalFilterClass.getName());
        }
    }
}

