/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.extended;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public interface CryptoParametersJ8 {
    public static final String CLEAR_CODE_DEFAULT = "J8_AES064;";
    public static final TYPES DEFAULT_TYPE = TYPES.PBE;
    public static final List[] LISTS = new List[]{Arrays.stream(TYPES.values()).map(t -> t.toString()).collect(Collectors.toList()), Arrays.stream(TYPES_IMPL.values()).map(t -> t.toString()).collect(Collectors.toList())};
    public static final String[] PROVIDER_TYPES = new String[]{"AlgorithmParameters", "Cipher"};

    public static List<String> getSupportedAlgos(List<String> algoList, String type, boolean exact) {
        ArrayList<String> result = new ArrayList<String>();
        Provider[] p = Security.getProviders();
        List<Provider> providerList = Arrays.asList(p);
        for (Provider provider : providerList) {
            result.addAll(Collections.list(provider.keys()).stream().map(t -> t.toString()).filter(x -> exact ? x.startsWith(type) && algoList.contains(x.replaceAll(type + ".", "")) : x.matches("(" + String.join((CharSequence)"|", PROVIDER_TYPES) + ").*$") && algoList.stream().anyMatch(y -> y.contains(x.replaceAll(type + ".", "")))).map(x -> exact ? x.replaceAll(type + ".", "") : x.replaceAll("(" + String.join((CharSequence)"|", PROVIDER_TYPES) + ").", "")).collect(Collectors.toList()));
        }
        return result;
    }

    public static List<String> init() {
        List<Object> result = new ArrayList();
        List defaultSupportedTypes = LISTS[0];
        String providerType = PROVIDER_TYPES[0];
        result = CryptoParametersJ8.getSupportedAlgos(defaultSupportedTypes, providerType, true);
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>(result);
        resultSet.addAll(CryptoParametersJ8.getSupportedAlgos(defaultSupportedTypes, providerType, false));
        List algoList = LISTS[1];
        String type = PROVIDER_TYPES[1];
        List<String> result3 = CryptoParametersJ8.getSupportedAlgos(algoList, type, true);
        defaultSupportedTypes.stream().forEach(c -> {
            if (result3.stream().anyMatch(x -> x.contains((CharSequence)c))) {
                resultSet.add((String)c);
            }
        });
        return new ArrayList<String>(resultSet);
    }

    public static enum TYPES {
        PBE,
        GCM;


        public String getClearCode() {
            return this.equals((Object)PBE) ? TYPES_IMPL.ALGORITHM_J8_PBE.getClearCode() : TYPES_IMPL.ALGORITHM_J8_GCM.getClearCode();
        }
    }

    public static enum TYPES_IMPL {
        ALGORITHM_J8_PBE("PBEWithHmacSHA256AndAES_256"),
        ALGORITHM_J8_GCM("AES_128/GCM/NoPadding");

        private final String algorithm;

        private TYPES_IMPL(String algo) {
            this.algorithm = algo;
        }

        public String toString() {
            return this.algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getClearCode() {
            return String.format("J8%1$s;", this.algorithm.subSequence(this.algorithm.indexOf("AES_"), this.algorithm.indexOf("AES_") + 7));
        }
    }
}

