/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.jmx.ApplicationSettings;
import org.apache.wicket.jmx.DebugSettings;
import org.apache.wicket.jmx.MarkupSettings;
import org.apache.wicket.jmx.PageSettings;
import org.apache.wicket.jmx.RequestCycleSettings;
import org.apache.wicket.jmx.RequestLogger;
import org.apache.wicket.jmx.ResourceSettings;
import org.apache.wicket.jmx.SecuritySettings;
import org.apache.wicket.jmx.SessionSettings;
import org.apache.wicket.jmx.StoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer
implements IInitializer {
    private static Logger log = LoggerFactory.getLogger(Initializer.class);
    private MBeanServer mbeanServer = null;
    private final List<ObjectName> registered = new ArrayList<ObjectName>();

    public void destroy(Application application) {
        for (ObjectName objectName : this.registered) {
            try {
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void init(Application application) {
        try {
            String name = application.getName();
            String agentId = null;
            try {
                agentId = System.getProperty("wicket.mbean.server.agentid");
            }
            catch (SecurityException e) {
                log.warn("not allowed to read property wicket.mbean.server.agentid due to security settings; ignoring");
            }
            if (agentId != null) {
                ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(agentId);
                if (!mbeanServers.isEmpty()) {
                    this.mbeanServer = mbeanServers.get(0);
                } else {
                    log.error("unable to find mbean server with agent id " + agentId);
                }
            }
            if (this.mbeanServer == null) {
                String impl = null;
                try {
                    impl = System.getProperty("wicket.mbean.server.class");
                }
                catch (SecurityException e) {
                    log.warn("not allowed to read property wicket.mbean.server.class due to security settings; ignoring");
                }
                if (impl != null) {
                    ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
                    if (!mbeanServers.isEmpty()) {
                        for (MBeanServer mbs : mbeanServers) {
                            if (!mbs.getClass().getName().equals(impl)) continue;
                            this.mbeanServer = mbs;
                            break;
                        }
                    }
                    if (this.mbeanServer == null) {
                        log.error("unable to find mbean server of type '{}'", (Object)impl);
                    }
                }
            }
            if (this.mbeanServer == null) {
                this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            log.info("registering Wicket mbeans with server '{}'", (Object)this.mbeanServer);
            String domain = "org.apache.wicket.app." + name;
            ObjectName appBeanName = new ObjectName(domain + ":type=Application");
            String tempDomain = domain;
            int i = 0;
            while (this.mbeanServer.isRegistered(appBeanName)) {
                tempDomain = name + "-" + i++;
                appBeanName = new ObjectName(tempDomain + ":type=Application");
            }
            domain = tempDomain;
            org.apache.wicket.jmx.Application appBean = new org.apache.wicket.jmx.Application(application);
            this.register(appBean, appBeanName);
            this.register(new ApplicationSettings(application), new ObjectName(domain + ":type=Application,name=ApplicationSettings"));
            this.register(new DebugSettings(application), new ObjectName(domain + ":type=Application,name=DebugSettings"));
            this.register(new MarkupSettings(application), new ObjectName(domain + ":type=Application,name=MarkupSettings"));
            this.register(new ResourceSettings(application), new ObjectName(domain + ":type=Application,name=ResourceSettings"));
            this.register(new PageSettings(application), new ObjectName(domain + ":type=Application,name=PageSettings"));
            this.register(new RequestCycleSettings(application), new ObjectName(domain + ":type=Application,name=RequestCycleSettings"));
            this.register(new SecuritySettings(application), new ObjectName(domain + ":type=Application,name=SecuritySettings"));
            this.register(new SessionSettings(application), new ObjectName(domain + ":type=Application,name=SessionSettings"));
            this.register(new StoreSettings(application), new ObjectName(domain + ":type=Application,name=StoreSettings"));
            RequestLogger sessionsBean = new RequestLogger(application);
            ObjectName sessionsBeanName = new ObjectName(domain + ":type=RequestLogger");
            this.register(sessionsBean, sessionsBeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return "Wicket JMX initializer";
    }

    private void register(Object o, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mbeanServer.registerMBean(o, objectName);
        this.registered.add(objectName);
    }
}

