/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.diskstore.browser;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.devutils.diskstore.DebugDiskDataStore;
import org.apache.wicket.devutils.diskstore.DebugPageManagerProvider;
import org.apache.wicket.devutils.diskstore.browser.PageWindowDescription;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.serialize.ISerializer;

class PageWindowColumn
extends PropertyColumn<PageWindowDescription, String> {
    public PageWindowColumn(IModel<String> displayModel, String propertyExpression) {
        super(displayModel, propertyExpression);
    }

    public void populateItem(Item<ICellPopulator<PageWindowDescription>> cellItem, String componentId, IModel<PageWindowDescription> rowModel) {
        String label;
        PageWindowDescription windowDescription = (PageWindowDescription)rowModel.getObject();
        if ("name".equals(this.getPropertyExpression())) {
            int pageId = windowDescription.getId();
            DebugPageManagerProvider pageManagerProvider = (DebugPageManagerProvider)Application.get().getPageManagerProvider();
            DebugDiskDataStore dataStore = pageManagerProvider.getDataStore();
            String sessionId = windowDescription.getSessionId();
            byte[] data = dataStore.getData(sessionId, pageId);
            ISerializer serializer = Application.get().getFrameworkSettings().getSerializer();
            Object page = serializer.deserialize(data);
            label = page.getClass().getName();
        } else {
            label = "id".equals(this.getPropertyExpression()) ? Integer.toString(windowDescription.getId()) : ("size".equals(this.getPropertyExpression()) ? Integer.toString(windowDescription.getSize()) : "unknown: " + this.getPropertyExpression());
        }
        cellItem.add(new Component[]{new Label(componentId, label)});
    }
}

